/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.analyzer;

import de.dagere.peass.measurement.rca.analyzer.TreeAnalyzer;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.treeanalysis.TreeUtil;
import java.util.LinkedList;
import java.util.List;

public class CompleteTreeAnalyzer
implements TreeAnalyzer {
    private final List<CallTreeNode> treeStructureDiffering = new LinkedList<CallTreeNode>();
    private final List<CallTreeNode> allNodesPredecessor = new LinkedList<CallTreeNode>();

    public CompleteTreeAnalyzer(CallTreeNode root, CallTreeNode rootPredecessor) {
        root.setOtherKiekerPattern(rootPredecessor.getKiekerPattern());
        rootPredecessor.setOtherCommitNode(root);
        rootPredecessor.setOtherKiekerPattern(root.getKiekerPattern());
        this.allNodesPredecessor.add(rootPredecessor);
        this.mapAllNodes(root, rootPredecessor);
    }

    private void mapAllNodes(CallTreeNode current, CallTreeNode currentPredecessor) {
        TreeUtil.findChildMapping(current, currentPredecessor);
        this.findTreeStructureDiffering(current, currentPredecessor);
        for (CallTreeNode currentChild : current.getChildren()) {
            CallTreeNode predecessorChild = currentChild.getOtherCommitNode();
            this.mapAllNodes(currentChild, predecessorChild);
            this.allNodesPredecessor.add(predecessorChild);
        }
    }

    private void findTreeStructureDiffering(CallTreeNode current, CallTreeNode currentPredecessor) {
        current.getChildren().forEach(child -> {
            if (child.getCall().equals("ADDED")) {
                this.treeStructureDiffering.add(child.getOtherCommitNode());
            }
        });
        currentPredecessor.getChildren().forEach(child -> {
            if (child.getCall().equals("ADDED")) {
                this.treeStructureDiffering.add(child.getOtherCommitNode());
            }
        });
    }

    public List<CallTreeNode> getTreeStructureDiffering() {
        return this.treeStructureDiffering;
    }

    @Override
    public List<CallTreeNode> getMeasurementNodesPredecessor() {
        return this.allNodesPredecessor;
    }
}

