/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.analyzer;

import de.dagere.peass.analysis.properties.ChangedMethodManager;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.measurement.rca.analyzer.StructureChangeTreeAnalyzer;
import de.dagere.peass.measurement.rca.analyzer.TreeAnalyzer;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SourceChangeTreeAnalyzer
implements TreeAnalyzer {
    private static final Logger LOG = LogManager.getLogger(SourceChangeTreeAnalyzer.class);
    private final List<CallTreeNode> includedNodes = new LinkedList<CallTreeNode>();
    private final MeasurementConfig config;

    public SourceChangeTreeAnalyzer(CallTreeNode root, CallTreeNode rootPredecessor, ChangedMethodManager manager, MeasurementConfig config) {
        StructureChangeTreeAnalyzer structureChangeTreeAnalyzer = new StructureChangeTreeAnalyzer(root, rootPredecessor);
        List<CallTreeNode> includableNodes = structureChangeTreeAnalyzer.getMeasurementNodesPredecessor();
        this.config = config;
        Set<CallTreeNode> includeNodes = this.calculateIncludedNodesSourceChange(manager, includableNodes);
        this.calculateIncludeNodesStructureChange(structureChangeTreeAnalyzer, includeNodes);
        this.includedNodes.addAll(includeNodes);
    }

    private void calculateIncludeNodesStructureChange(StructureChangeTreeAnalyzer structureChangeTreeAnalyzer, Set<CallTreeNode> includeNodes) {
        List<CallTreeNode> unequalStructureNodesPredecessor = structureChangeTreeAnalyzer.getUnequalStructureNodesPredecessor();
        for (CallTreeNode unequalStructureNode : unequalStructureNodesPredecessor) {
            LOG.info("Node {} has structure change, so itself and all parents are included", (Object)unequalStructureNode);
            this.addParents(unequalStructureNode, includeNodes);
        }
    }

    private Set<CallTreeNode> calculateIncludedNodesSourceChange(ChangedMethodManager manager, List<CallTreeNode> includableNodes) {
        HashSet<CallTreeNode> includeNodes = new HashSet<CallTreeNode>();
        for (CallTreeNode node : includableNodes) {
            File mainSourceFile = manager.getMethodMainFile(this.config.getFixedCommitConfig().getCommit(), node.toEntity());
            File oldSourceFile = manager.getMethodOldFile(this.config.getFixedCommitConfig().getCommit(), node.toEntity());
            if (!mainSourceFile.exists() && !oldSourceFile.exists()) {
                File diffSourceFile = manager.getMethodDiffFile(this.config.getFixedCommitConfig().getCommit(), node.toEntity());
                if (diffSourceFile.exists()) {
                    LOG.debug("Node {} has no change", (Object)node);
                    continue;
                }
                LOG.error("Error - file {} did not exist", (Object)diffSourceFile);
                continue;
            }
            LOG.info("Node {} has change, so itself and all parents are included", (Object)node);
            this.addParents(node, includeNodes);
        }
        LOG.debug("Identified {} included nodes", (Object)includableNodes.size());
        return includeNodes;
    }

    public void addParents(CallTreeNode current, Set<CallTreeNode> includeNodes) {
        includeNodes.add(current);
        if (current.getParent() != null) {
            this.addParents(current.getParent(), includeNodes);
        }
    }

    @Override
    public List<CallTreeNode> getMeasurementNodesPredecessor() {
        return this.includedNodes;
    }
}

