/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.analyzer;

import de.dagere.peass.measurement.rca.analyzer.TreeAnalyzer;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.treeanalysis.TreeUtil;
import java.util.LinkedList;
import java.util.List;

public class StructureChangeTreeAnalyzer
implements TreeAnalyzer {
    private final List<CallTreeNode> equalStructureNodes = new LinkedList<CallTreeNode>();
    private final List<CallTreeNode> unequalStructureNodesPredecessor = new LinkedList<CallTreeNode>();

    public StructureChangeTreeAnalyzer(CallTreeNode root, CallTreeNode rootPredecessor) {
        root.setOtherCommitNode(rootPredecessor);
        rootPredecessor.setOtherCommitNode(root);
        rootPredecessor.setOtherKiekerPattern(root.getKiekerPattern());
        if (root.getKiekerPattern().equals(rootPredecessor.getKiekerPattern())) {
            this.equalStructureNodes.add(rootPredecessor);
            this.mapAllNodes(root, rootPredecessor);
        }
    }

    private void mapAllNodes(CallTreeNode current, CallTreeNode currentPredecessor) {
        TreeUtil.findChildMapping(current, currentPredecessor);
        for (CallTreeNode currentChild : current.getChildren()) {
            CallTreeNode childPredecessor = currentChild.getOtherCommitNode();
            if (currentChild.getKiekerPattern().equals(childPredecessor.getKiekerPattern())) {
                this.equalStructureNodes.add(childPredecessor);
                this.mapAllNodes(currentChild, childPredecessor);
                continue;
            }
            this.unequalStructureNodesPredecessor.add(childPredecessor);
        }
    }

    @Override
    public List<CallTreeNode> getMeasurementNodesPredecessor() {
        return this.equalStructureNodes;
    }

    public List<CallTreeNode> getUnequalStructureNodesPredecessor() {
        return this.unequalStructureNodesPredecessor;
    }
}

