/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.data;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;

public abstract class BasicNode {
    protected String call;
    protected String kiekerPattern;
    private String otherKiekerPattern;
    protected String module;

    public BasicNode(String call, String kiekerPattern, String otherKiekerPattern) {
        int moduleSeparatorIndex = call.lastIndexOf("\u00a7");
        if (moduleSeparatorIndex != -1) {
            this.call = call.substring(moduleSeparatorIndex + 1);
            this.module = call.substring(0, moduleSeparatorIndex);
            this.kiekerPattern = kiekerPattern != null ? kiekerPattern.replaceFirst(this.module + "\u00a7", "") : null;
            this.otherKiekerPattern = otherKiekerPattern != null ? otherKiekerPattern.replaceFirst(this.module + "\u00a7", "") : null;
        } else {
            this.call = call;
            this.kiekerPattern = kiekerPattern;
            this.otherKiekerPattern = otherKiekerPattern;
        }
        if (kiekerPattern != null && !"ADDED".equals(kiekerPattern) && !kiekerPattern.contains(this.call.replace("#", "."))) {
            throw new RuntimeException("Pattern " + kiekerPattern + " must contain " + this.call.replace("#", "."));
        }
        if (kiekerPattern != null && kiekerPattern.contains("<init>") && !kiekerPattern.contains("new")) {
            throw new RuntimeException("Pattern " + kiekerPattern + " not legal - Constructor must contain new as return type!");
        }
        if (otherKiekerPattern != null && kiekerPattern.contains("<init>") && !kiekerPattern.contains("new")) {
            throw new RuntimeException("Pattern " + kiekerPattern + " not legal - Constructor must contain new as return type!");
        }
        if (kiekerPattern != null && kiekerPattern.contains("new new ")) {
            throw new RuntimeException("Illegal duplication of new identifier!");
        }
        if (otherKiekerPattern != null && otherKiekerPattern.contains("new new ")) {
            throw new RuntimeException("Illegal duplication of new identifier!");
        }
        if (!(kiekerPattern == null || "ADDED".equals(kiekerPattern) || kiekerPattern.contains("(") && kiekerPattern.contains(")"))) {
            throw new RuntimeException("KiekerPattern " + kiekerPattern + " needs to contain parenthesis, at least () for empty parameters");
        }
        if (!(otherKiekerPattern == null || "ADDED".equals(otherKiekerPattern) || otherKiekerPattern.contains("(") && otherKiekerPattern.contains(")"))) {
            throw new RuntimeException("KiekerPattern " + otherKiekerPattern + " needs to contain parenthesis, at least () for empty parameters");
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getCall() {
        return this.call;
    }

    public String getKiekerPattern() {
        return this.kiekerPattern;
    }

    public String getOtherKiekerPattern() {
        return this.otherKiekerPattern;
    }

    public void setOtherKiekerPattern(String otherKiekerPattern) {
        this.otherKiekerPattern = otherKiekerPattern;
    }

    public abstract List<? extends BasicNode> getChildren();
}

