/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.dagere.nodeDiffDetector.data.MethodCall;
import de.dagere.peass.config.FixedCommitConfig;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.measurement.rca.data.BasicNode;
import de.dagere.peass.measurement.rca.data.CallTreeNodeDeserializer;
import de.dagere.peass.measurement.rca.data.CallTreeStatistics;
import de.dagere.peass.measurement.rca.data.OneVMResult;
import de.dagere.peass.measurement.statistics.StatisticUtil;
import de.dagere.peass.measurement.statistics.bimodal.CompareData;
import de.dagere.peass.measurement.statistics.data.TestcaseStatistic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@JsonDeserialize(using=CallTreeNodeDeserializer.class)
public class CallTreeNode
extends BasicNode {
    private static final Logger LOG = LogManager.getLogger(CallTreeNode.class);
    @JsonIgnore
    private final CallTreeNode parent;
    protected final List<CallTreeNode> children = new ArrayList<CallTreeNode>();
    protected final Map<String, CallTreeStatistics> data = new HashMap<String, CallTreeStatistics>();
    @JsonIgnore
    protected MeasurementConfig config;
    private CallTreeNode otherCommitNode;

    public CallTreeNode(String call, String kiekerPattern, String otherKiekerPattern, MeasurementConfig config) {
        super(call, kiekerPattern, otherKiekerPattern);
        this.parent = null;
        this.config = config;
    }

    protected CallTreeNode(String call, String kiekerPattern, String otherKiekerPattern, CallTreeNode parent) {
        super(call, kiekerPattern, otherKiekerPattern);
        this.parent = parent;
        this.config = parent.config;
    }

    public void setConfig(MeasurementConfig config) {
        this.config = config;
    }

    public MeasurementConfig getConfig() {
        return this.config;
    }

    public List<CallTreeNode> getChildren() {
        return this.children;
    }

    public CallTreeNode appendChild(String call, String kiekerPattern, String otherKiekerPattern) {
        CallTreeNode added = new CallTreeNode(call, kiekerPattern, otherKiekerPattern, this);
        this.children.add(added);
        return added;
    }

    public CallTreeNode getParent() {
        return this.parent;
    }

    public void addMeasurement(String commit, Long duration) {
        this.checkDataAddPossible(commit);
        LOG.trace("Adding measurement: {} Call: {}", (Object)commit, (Object)this.call);
        CallTreeStatistics callTreeStatistics = this.data.get(commit);
        callTreeStatistics.addMeasurement(duration);
    }

    public void addAggregatedMeasurement(String commit, List<StatisticalSummary> statistic) {
        this.checkDataAddPossible(commit);
        StatisticUtil.removeWarmup(this.config.getNodeWarmup(), statistic);
        this.data.get(commit).addAggregatedMeasurement(statistic);
    }

    private void checkDataAddPossible(String commit) {
        if (this.getOtherKiekerPattern() == null) {
            throw new RuntimeException("Other commit node needs to be defined before measurement! Node: " + this.call);
        }
        if (this.getOtherKiekerPattern().equals("ADDED") && commit.equals(this.config.getFixedCommitConfig().getCommit())) {
            LOG.error("Error occured in commit {}", (Object)commit);
            LOG.error("Node: {}", (Object)this.kiekerPattern);
            LOG.error("Other commit node: {}", (Object)this.getOtherKiekerPattern());
            throw new RuntimeException("Added methods may not contain data, trying to add data for " + commit);
        }
        if (this.call.equals("ADDED") && commit.equals(this.config.getFixedCommitConfig().getCommitOld())) {
            throw new RuntimeException("Added methods may not contain data, trying to add data for " + commit);
        }
    }

    public boolean hasMeasurement(String commit) {
        return this.data.get(commit).getResults().size() > 0;
    }

    public List<OneVMResult> getResults(String commit) {
        CallTreeStatistics statistics = this.data.get(commit);
        return statistics != null ? statistics.getResults() : null;
    }

    public void initVMData(String commit) {
        CallTreeStatistics statistics = this.data.get(commit);
        LOG.debug("Adding VM: {} {} VMs: {}", (Object)this.call, (Object)commit, (Object)statistics.getResults().size());
        statistics.newResult();
    }

    private void newCommit(String commit) {
        LOG.trace("Adding commit: {}", (Object)commit);
        CallTreeStatistics statistics = this.data.get(commit);
        if (statistics == null) {
            statistics = new CallTreeStatistics(this.config.getNodeWarmup());
            this.data.put(commit, statistics);
        }
    }

    public CompareData getComparableStatistics(String commitOld, String commit) {
        List<OneVMResult> dataOld = this.data.get(commitOld) != null ? this.data.get(commitOld).getResults() : null;
        List<OneVMResult> dataCurrent = this.data.get(commit) != null ? this.data.get(commit).getResults() : null;
        CompareData cd = CompareData.createCompareDataFromOneVMResults(dataOld, dataCurrent);
        return cd;
    }

    public SummaryStatistics getStatistics(String commit) {
        LOG.trace("Getting data: {}", (Object)commit);
        CallTreeStatistics statistics = this.data.get(commit);
        return statistics != null ? statistics.getStatistics() : null;
    }

    public void createStatistics(String commit) {
        LOG.debug("Creating statistics: {} Call: {}", (Object)commit, (Object)this.call);
        CallTreeStatistics callTreeStatistics = this.data.get(commit);
        callTreeStatistics.createStatistics(this.config.getStatisticsConfig());
        LOG.debug("Mean: " + callTreeStatistics.getStatistics().getMean() + " " + callTreeStatistics.getStatistics().getStandardDeviation());
    }

    public String toString() {
        return this.kiekerPattern.toString();
    }

    public MethodCall toEntity() {
        MethodCall entity;
        if (this.call.equals("ADDED")) {
            String otherKiekerPattern = this.getOtherKiekerPattern();
            String otherCall = otherKiekerPattern.substring(otherKiekerPattern.lastIndexOf(32), otherKiekerPattern.indexOf(40));
            return MethodCall.createMethodCallFromString((String)otherCall);
        }
        int index = this.call.lastIndexOf("#");
        String method = this.call.substring(index + 1);
        if (method.contains("(")) {
            entity = new MethodCall(this.call.substring(0, index), this.module, method.substring(0, method.indexOf(40)));
            entity.createParameters(method.substring(method.indexOf(40)));
        } else {
            entity = new MethodCall(this.call.substring(0, index), this.module, method);
        }
        entity.createParameters(this.getParameters());
        return entity;
    }

    @JsonIgnore
    public TestcaseStatistic getTestcaseStatistic() {
        LOG.debug("Creating statistics for {} {} Keys: {}", (Object)this.config.getFixedCommitConfig().getCommit(), (Object)this.config.getFixedCommitConfig().getCommitOld(), this.data.keySet());
        CallTreeStatistics currentStatistics = this.data.get(this.config.getFixedCommitConfig().getCommit());
        SummaryStatistics current = currentStatistics.getStatistics();
        CallTreeStatistics predecessorStatistics = this.data.get(this.config.getFixedCommitConfig().getCommitOld());
        SummaryStatistics predecessor = predecessorStatistics.getStatistics();
        try {
            TestcaseStatistic testcaseStatistic = new TestcaseStatistic((StatisticalSummary)predecessor, (StatisticalSummary)current, predecessorStatistics.getCalls(), currentStatistics.getCalls());
            return testcaseStatistic;
        }
        catch (NumberIsTooSmallException t) {
            LOG.debug("Data: " + current.getN() + " " + predecessor.getN());
            String otherCall = this.getOtherKiekerPattern() != null ? this.getOtherKiekerPattern() : "Not Existing";
            throw new RuntimeException("Could not read " + this.call + " Other Version: " + otherCall, t);
        }
        catch (TestcaseStatistic.TestcaseStatisticException t) {
            LOG.debug("Data: " + current.getN() + " " + predecessor.getN());
            String otherCall = this.getOtherKiekerPattern() != null ? this.getOtherKiekerPattern() : "Not Existing";
            throw new RuntimeException("Could not read " + this.call + " Other Version: " + otherCall, t);
        }
    }

    @JsonIgnore
    public TestcaseStatistic getPartialTestcaseStatistic() {
        CallTreeStatistics previousVersionStatistics;
        SummaryStatistics previous;
        CallTreeStatistics currentVersionStatistics = this.data.get(this.config.getFixedCommitConfig().getCommit());
        SummaryStatistics current = currentVersionStatistics.getStatistics();
        if (this.firstHasValues(current, previous = (previousVersionStatistics = this.data.get(this.config.getFixedCommitConfig().getCommitOld())).getStatistics())) {
            TestcaseStatistic testcaseStatistic = new TestcaseStatistic((StatisticalSummary)previous, (StatisticalSummary)current, 0L, currentVersionStatistics.getCalls());
            testcaseStatistic.setChange(true);
            return testcaseStatistic;
        }
        if (this.firstHasValues(previous, current)) {
            TestcaseStatistic testcaseStatistic = new TestcaseStatistic((StatisticalSummary)previous, (StatisticalSummary)current, previousVersionStatistics.getCalls(), 0L);
            testcaseStatistic.setChange(true);
            return testcaseStatistic;
        }
        if (!(current != null && current.getN() != 0L || previous != null && previous.getN() != 0L)) {
            LOG.error("Could not measure {}", (Object)this);
            TestcaseStatistic testcaseStatistic = new TestcaseStatistic((StatisticalSummary)previous, (StatisticalSummary)current, 0L, 0L);
            testcaseStatistic.setChange(true);
            return testcaseStatistic;
        }
        throw new RuntimeException("Partial statistics should exactly be created if one node is unmeasurable");
    }

    private boolean firstHasValues(SummaryStatistics first, SummaryStatistics second) {
        return (second == null || second.getN() == 0L) && first != null && first.getN() > 0L;
    }

    public void initCommitData() {
        FixedCommitConfig fixedCommitConfig = this.config.getFixedCommitConfig();
        LOG.debug("Init commit data: {}", (Object)fixedCommitConfig.getCommit(), (Object)fixedCommitConfig.getCommitOld());
        this.resetStatistics();
        this.newCommit(fixedCommitConfig.getCommitOld());
        this.newCommit(fixedCommitConfig.getCommit());
    }

    @JsonIgnore
    public int getTreeSize() {
        int size = 1;
        for (CallTreeNode child : this.children) {
            size += child.getTreeSize();
        }
        return size;
    }

    protected void resetStatistics() {
        this.data.values().forEach(statistics -> statistics.resetResults());
    }

    @JsonIgnore
    public CallTreeNode getOtherCommitNode() {
        return this.otherCommitNode;
    }

    public void setOtherCommitNode(CallTreeNode otherVersionNode) {
        this.otherCommitNode = otherVersionNode;
    }

    @JsonIgnore
    public String getMethod() {
        String method = this.call.substring(this.call.lastIndexOf(35));
        return method;
    }

    @JsonIgnore
    public String getParameters() {
        String parameters = this.kiekerPattern.substring(this.kiekerPattern.indexOf(40));
        return parameters;
    }

    @JsonIgnore
    public int getEss() {
        return this.parent != null ? this.parent.getEss() + 1 : 0;
    }

    @JsonIgnore
    public int getEoi(String commit) {
        int eoi;
        if (this.isAdded(commit)) {
            return -1;
        }
        if (this.parent != null) {
            List notAddedSiblingList = this.parent.getChildren().stream().filter(predecessor -> !predecessor.isAdded(commit)).collect(Collectors.toList());
            int predecessorIndex = notAddedSiblingList.indexOf(this) - 1;
            if (predecessorIndex >= 0) {
                CallTreeNode predecessor2 = (CallTreeNode)notAddedSiblingList.get(predecessorIndex);
                int predecessorEOI = predecessor2.getEoi(commit);
                eoi = predecessorEOI + predecessor2.getAllChildCount(commit) + 1;
            } else {
                eoi = this.parent.getEoi(commit) + 1;
            }
        } else {
            eoi = 0;
        }
        return eoi;
    }

    private boolean isAdded(String commit) {
        FixedCommitConfig executionConfig = this.config.getFixedCommitConfig();
        if (executionConfig.getCommitOld().equals(commit) && this.call.equals("ADDED")) {
            return true;
        }
        String otherKiekerPattern = this.getOtherKiekerPattern();
        return executionConfig.getCommit().equals(commit) && "ADDED".equals(otherKiekerPattern);
    }

    private int getAllChildCount(String commit) {
        int childs = 0;
        for (CallTreeNode child : this.children) {
            boolean currentVersionValidNode = !child.isAdded(commit);
            if (!currentVersionValidNode) continue;
            int usableChildCount = child.getAllChildCount(commit);
            childs += usableChildCount + 1;
        }
        return childs;
    }

    @JsonIgnore
    public int getPosition() {
        if (this.parent != null) {
            for (int childIndex = 0; childIndex < this.parent.getChildren().size(); ++childIndex) {
                if (this.parent.getChildren().get(childIndex) != this) continue;
                return childIndex;
            }
            return -1;
        }
        return 0;
    }

    public long getCallCount(String commit) {
        return this.data.get(commit).getResults().stream().mapToLong(result -> result.getCalls()).sum();
    }

    public int hashCode() {
        return this.kiekerPattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CallTreeNode) {
            CallTreeNode other = (CallTreeNode)obj;
            boolean equal = other.getKiekerPattern().equals(this.kiekerPattern);
            if (equal) {
                if (this.parent == null != (other.parent == null)) {
                    equal = false;
                } else if (this.parent != null) {
                    equal &= this.parent.equals(other.parent);
                    equal &= this.getPosition() == other.getPosition();
                }
            }
            return equal;
        }
        return false;
    }

    @JsonIgnore
    public CallTreeNode getChildByKiekerPattern(String kiekerPattern) {
        for (CallTreeNode child : this.children) {
            if (!child.getKiekerPattern().equals(kiekerPattern)) continue;
            return child;
        }
        return null;
    }
}

