/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.data;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import java.io.IOException;

class CallTreeNodeDeserializer
extends JsonDeserializer<CallTreeNode> {
    CallTreeNodeDeserializer() {
    }

    public CallTreeNode deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        String call = node.get("call").asText();
        String kiekerPattern = !node.get("kiekerPattern").isNull() ? node.get("kiekerPattern").asText() : null;
        JsonNode moduleNode = node.get("module");
        String module = moduleNode != null && !moduleNode.isNull() ? moduleNode.asText() : null;
        JsonNode children = node.get("children");
        CallTreeNode root = new CallTreeNode(call, kiekerPattern, null, (MeasurementConfig)null);
        root.setModule(module);
        this.handleChild(children, root);
        return root;
    }

    private void handleChild(JsonNode children, CallTreeNode parent) {
        for (JsonNode child : children) {
            String call = child.get("call").asText();
            String kiekerPattern = child.get("kiekerPattern").asText();
            JsonNode moduleNode = child.get("module");
            String module = moduleNode != null && !moduleNode.isNull() ? moduleNode.asText() : null;
            CallTreeNode created = parent.appendChild(call, kiekerPattern, null);
            created.setModule(module);
            this.handleChild(child.get("children"), created);
        }
    }
}

