/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.data;

import de.dagere.peass.measurement.rca.data.OneVMResult;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public class CallTreeResult
implements OneVMResult {
    private final int warmup;
    private int measured = 0;
    private final SummaryStatistics statistics = new SummaryStatistics();

    public CallTreeResult(int warmup) {
        this.warmup = warmup;
    }

    @Override
    public double getAverage() {
        return this.statistics.getMean();
    }

    public void addValue(Long value) {
        ++this.measured;
        if (this.measured > this.warmup) {
            this.statistics.addValue((double)value.longValue());
        }
    }

    @Override
    public long getCalls() {
        return this.measured;
    }

    @Override
    public List<StatisticalSummary> getValues() {
        LinkedList<StatisticalSummary> values = new LinkedList<StatisticalSummary>();
        values.add((StatisticalSummary)this.statistics);
        return values;
    }
}

