/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.data;

import de.dagere.peass.config.StatisticsConfig;
import de.dagere.peass.measurement.rca.data.CallTreeResult;
import de.dagere.peass.measurement.rca.data.FinalCallTreeResult;
import de.dagere.peass.measurement.rca.data.OneVMResult;
import de.dagere.peass.measurement.statistics.data.OutlierRemoverVMResults;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public class CallTreeStatistics {
    private final int warmup;
    private final List<OneVMResult> results = new ArrayList<OneVMResult>();
    protected final SummaryStatistics statistics = new SummaryStatistics();

    public CallTreeStatistics(int warmup) {
        this.warmup = warmup;
    }

    public void addMeasurement(Long duration) {
        CallTreeResult current = (CallTreeResult)this.results.get(this.results.size() - 1);
        current.addValue(duration);
    }

    public void addAggregatedMeasurement(List<StatisticalSummary> statistic) {
        this.results.add(new FinalCallTreeResult(statistic));
    }

    public void newResult() {
        this.results.add(new CallTreeResult(this.warmup));
    }

    public void createStatistics(StatisticsConfig config) {
        this.statistics.clear();
        OutlierRemoverVMResults.getValuesWithoutOutliers(this.results, this.statistics, config);
    }

    public List<OneVMResult> getResults() {
        return this.results;
    }

    public SummaryStatistics getStatistics() {
        return this.statistics;
    }

    public void resetResults() {
        this.results.clear();
    }

    public long getCalls() {
        return this.results.stream().mapToLong(result -> result.getCalls()).sum();
    }
}

