/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.measurement.rca.CauseSearcherConfig;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.serialization.MeasuredNode;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CauseSearchData {
    public static final String ADDED = "ADDED";
    private static final Logger LOG = LogManager.getLogger(CauseSearchData.class);
    private MeasurementConfig measurementConfig;
    private CauseSearcherConfig causeConfig;
    private MeasuredNode nodes;
    private Map<CallTreeNode, MeasuredNode> current = new HashMap<CallTreeNode, MeasuredNode>();

    public CauseSearchData() {
    }

    public CauseSearchData(MeasurementConfig config, CauseSearcherConfig causeConfig) {
        this.measurementConfig = config;
        this.causeConfig = causeConfig;
    }

    public MeasurementConfig getMeasurementConfig() {
        return this.measurementConfig;
    }

    public void setConfig(MeasurementConfig config) {
        this.measurementConfig = config;
    }

    public MeasuredNode getNodes() {
        return this.nodes;
    }

    public void setNodes(MeasuredNode nodes) {
        this.nodes = nodes;
        this.buildCurrentMap(nodes, null);
    }

    private void buildCurrentMap(MeasuredNode node, CallTreeNode parentStructure) {
        CallTreeNode nodeStructure = parentStructure != null ? parentStructure.appendChild(node.getCall(), node.getKiekerPattern(), node.getOtherKiekerPattern()) : new CallTreeNode(node.getCall(), node.getKiekerPattern(), node.getOtherKiekerPattern(), (MeasurementConfig)null);
        this.current.put(nodeStructure, node);
        for (MeasuredNode child : node.getChilds()) {
            this.buildCurrentMap(child, nodeStructure);
        }
    }

    public CauseSearcherConfig getCauseConfig() {
        return this.causeConfig;
    }

    public void setCauseConfig(CauseSearcherConfig causeConfig) {
        this.causeConfig = causeConfig;
    }

    @JsonIgnore
    public String getTestcase() {
        return this.causeConfig.getTestCase().getClazz() + "#" + this.causeConfig.getTestCase().getMethod();
    }

    @JsonIgnore
    public MeasuredNode addDiff(CallTreeNode rawDataNode) {
        MeasuredNode serializeNode = this.buildSerializedNode(rawDataNode);
        this.setStatistic(rawDataNode, serializeNode);
        this.current.put(rawDataNode, serializeNode);
        if (rawDataNode.getParent() == null) {
            this.nodes = serializeNode;
        } else {
            MeasuredNode parent = this.current.get(rawDataNode.getParent());
            if (parent != null) {
                parent.getChilds().add(serializeNode);
            }
        }
        return serializeNode;
    }

    private void setStatistic(CallTreeNode rawDataNode, MeasuredNode serializeNode) {
        if (!rawDataNode.getCall().equals(ADDED) && !rawDataNode.getOtherKiekerPattern().equals(ADDED)) {
            LOG.debug("Setting statistic: " + rawDataNode.getCall() + " " + rawDataNode.getOtherKiekerPattern());
            serializeNode.setStatistic(rawDataNode.getTestcaseStatistic());
        } else {
            LOG.debug(rawDataNode.getCall() + " " + rawDataNode.getOtherKiekerPattern());
            serializeNode.setStatistic(rawDataNode.getPartialTestcaseStatistic());
        }
    }

    private MeasuredNode buildSerializedNode(CallTreeNode rawDataNode) {
        MeasuredNode serializeNode = new MeasuredNode(rawDataNode.getCall(), rawDataNode.getKiekerPattern(), null);
        serializeNode.setModule(rawDataNode.getModule());
        serializeNode.setOtherKiekerPattern(rawDataNode.getOtherKiekerPattern() != null ? rawDataNode.getOtherKiekerPattern() : "UNKNOWN");
        return serializeNode;
    }

    @JsonIgnore
    public void addDetailDiff(CallTreeNode rawDataNode) {
        MeasuredNode serializeNode = this.addDiff(rawDataNode);
        serializeNode.setValues(rawDataNode, this.measurementConfig.getFixedCommitConfig().getCommit(), this.measurementConfig.getFixedCommitConfig().getCommitOld());
    }
}

