/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.kieker;

import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.CauseSearchFolders;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.measurement.rca.CauseSearcherConfig;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.kieker.TreeReader;
import de.dagere.peass.measurement.rca.kieker.TreeReaderFactory;
import de.dagere.peass.measurement.rca.treeanalysis.TreeUtil;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BothTreeReader {
    private static final Logger LOG = LogManager.getLogger(BothTreeReader.class);
    private CallTreeNode rootPredecessor;
    private CallTreeNode rootCurrent;
    private final CauseSearcherConfig causeSearchConfig;
    private final MeasurementConfig config;
    private final CauseSearchFolders folders;
    private final EnvironmentVariables env;
    final File potentialCacheFileOld;
    final File potentialCacheFile;

    public BothTreeReader(CauseSearcherConfig causeSearchConfig, MeasurementConfig config, CauseSearchFolders folders, EnvironmentVariables env) {
        this.causeSearchConfig = causeSearchConfig;
        this.config = config;
        this.folders = folders;
        this.env = env;
        File treeCacheFolder = folders.getTreeCacheFolder(config.getFixedCommitConfig().getCommit(), causeSearchConfig.getTestCase());
        this.potentialCacheFileOld = new File(treeCacheFolder, config.getFixedCommitConfig().getCommitOld());
        this.potentialCacheFile = new File(treeCacheFolder, config.getFixedCommitConfig().getCommit());
    }

    public void readCachedTrees() {
        if (!this.potentialCacheFile.exists()) {
            throw new RuntimeException("Cache not existing! " + this.potentialCacheFile.getAbsolutePath());
        }
        if (!this.potentialCacheFileOld.exists()) {
            throw new RuntimeException("Cache not existing! " + this.potentialCacheFileOld.getAbsolutePath());
        }
        try {
            this.rootPredecessor = (CallTreeNode)Constants.OBJECTMAPPER.readValue(this.potentialCacheFileOld, CallTreeNode.class);
            this.rootCurrent = (CallTreeNode)Constants.OBJECTMAPPER.readValue(this.potentialCacheFile, CallTreeNode.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.rootPredecessor.setConfig(this.config);
        this.setConfig(this.rootPredecessor);
        this.rootCurrent.setConfig(this.config);
        this.setConfig(this.rootCurrent);
    }

    private void setConfig(CallTreeNode node) {
        for (CallTreeNode child : node.getChildren()) {
            child.setConfig(this.config);
            this.setConfig(child);
        }
    }

    public void readTrees() {
        if (this.potentialCacheFile.exists() && this.potentialCacheFileOld.exists()) {
            LOG.info("Using cache!");
            this.readCachedTrees();
        } else {
            this.determineTrees();
            LOG.info("Writing to cache");
            try {
                Constants.OBJECTMAPPER.writeValue(this.potentialCacheFileOld, (Object)this.rootPredecessor);
                Constants.OBJECTMAPPER.writeValue(this.potentialCacheFile, (Object)this.rootCurrent);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void determineTrees() {
        TreeReader resultsManager = TreeReaderFactory.createTreeReader((PeassFolders)this.folders, this.config.getFixedCommitConfig().getCommitOld(), this.config, this.causeSearchConfig.isIgnoreEOIs(), this.env);
        this.rootPredecessor = resultsManager.getTree(this.causeSearchConfig.getTestCase(), this.config.getFixedCommitConfig().getCommitOld());
        TreeReader resultsManagerPrevious = TreeReaderFactory.createTreeReader((PeassFolders)this.folders, this.config.getFixedCommitConfig().getCommit(), this.config, this.causeSearchConfig.isIgnoreEOIs(), this.env);
        this.rootCurrent = resultsManagerPrevious.getTree(this.causeSearchConfig.getTestCase(), this.config.getFixedCommitConfig().getCommit());
        LOG.info("Traces equal: {}", (Object)TreeUtil.areTracesEqual(this.rootPredecessor, this.rootCurrent));
    }

    public CallTreeNode getRootPredecessor() {
        return this.rootPredecessor;
    }

    public CallTreeNode getRootCurrent() {
        return this.rootCurrent;
    }

    public EnvironmentVariables getEnv() {
        return this.env;
    }
}

