/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.kieker;

import java.io.File;
import kieker.model.system.model.Operation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KiekerPatternConverter {
    private static final Logger LOG = LogManager.getLogger(KiekerPatternConverter.class);

    public static String fixParameters(String kiekerCall) {
        LOG.trace("Fixing: {}", (Object)kiekerCall);
        int parametersBegin = kiekerCall.indexOf(40);
        if (parametersBegin != -1) {
            String namePart = kiekerCall.substring(0, parametersBegin);
            String parameterPart = kiekerCall.substring(parametersBegin);
            parameterPart = parameterPart.replace(" ", "");
            String result = namePart + parameterPart;
            return result;
        }
        return kiekerCall;
    }

    public static String getCall(String kiekerPattern) {
        try {
            if (!kiekerPattern.contains("(") || !kiekerPattern.contains(")")) {
                throw new RuntimeException(kiekerPattern + " is supposed to contain ( and )");
            }
            String beforeParameters = kiekerPattern.substring(0, kiekerPattern.indexOf(40));
            String afterSpace = beforeParameters.substring(beforeParameters.lastIndexOf(32) + 1);
            int dotIndex = afterSpace.lastIndexOf(46);
            if (dotIndex != -1) {
                String method = afterSpace.substring(dotIndex + 1);
                String clazz = afterSpace.substring(0, dotIndex);
                return clazz + "#" + method;
            }
            int doubleColonIndex = afterSpace.lastIndexOf("::");
            String method = afterSpace.substring(doubleColonIndex + 2);
            String clazz = afterSpace.substring(0, doubleColonIndex);
            return clazz + "::" + method;
        }
        catch (Exception e) {
            throw new RuntimeException("Parsing of " + kiekerPattern + " did not succeed", e);
        }
    }

    public static String addNewIfRequired(String kiekerPattern) {
        if (((String)kiekerPattern).contains("<init>")) {
            int beforeReturnType = ((String)kiekerPattern).lastIndexOf(" ");
            if (beforeReturnType == -1) {
                kiekerPattern = "new " + (String)kiekerPattern;
            } else {
                String returnType;
                String modifiers = ((String)kiekerPattern).substring(0, beforeReturnType);
                String remainder = ((String)kiekerPattern).substring(beforeReturnType + 1);
                String string = returnType = modifiers.lastIndexOf(" ") != -1 ? modifiers.substring(modifiers.lastIndexOf(" ") + 1) : modifiers;
                if (!"new".equals(returnType)) {
                    kiekerPattern = modifiers + " new " + remainder;
                }
            }
        }
        return kiekerPattern;
    }

    public static String getKiekerPattern(String kiekerCall) {
        int parametersBegin = kiekerCall.indexOf(40);
        String namePart = kiekerCall.substring(0, parametersBegin);
        namePart = KiekerPatternConverter.addNew(namePart);
        String parameterPart = kiekerCall.substring(parametersBegin);
        parameterPart = parameterPart.replace(" ", "");
        String result = namePart + parameterPart;
        return result;
    }

    private static String addNew(String kiekerCall) {
        if (kiekerCall.contains("<init>")) {
            Object repaired;
            String[] splitted = kiekerCall.split(" ");
            if (splitted[0].equals("public") || splitted[0].equals("protected") || splitted[0].equals("private")) {
                if (!splitted[1].equals("new")) {
                    repaired = splitted[0] + " new ";
                    for (int i = 1; i < splitted.length; ++i) {
                        repaired = (String)repaired + splitted[i] + " ";
                    }
                    repaired = ((String)repaired).substring(0, ((String)repaired).length() - 1);
                } else {
                    repaired = kiekerCall;
                }
            } else {
                repaired = !splitted[0].equals("new") ? "new " + kiekerCall : kiekerCall;
            }
            kiekerCall = repaired;
        }
        return kiekerCall;
    }

    public static String getKiekerPattern(Operation operation) {
        StringBuilder signatureBuilder = new StringBuilder();
        boolean containsNew = false;
        for (String modifier : operation.getSignature().getModifier()) {
            signatureBuilder.append(modifier).append(' ');
            if (!"new".equals(modifier)) continue;
            containsNew = true;
        }
        if (operation.getSignature().hasReturnType()) {
            signatureBuilder.append(operation.getSignature().getReturnType()).append(' ');
        } else if (!containsNew) {
            signatureBuilder.append("new").append(' ');
        }
        signatureBuilder.append(operation.getComponentType().getFullQualifiedName()).append('.').append(operation.getSignature().getName()).append('(');
        boolean first = true;
        for (String paramType : operation.getSignature().getParamTypeList()) {
            if (!first) {
                signatureBuilder.append(',');
            } else {
                first = false;
            }
            signatureBuilder.append(paramType);
        }
        signatureBuilder.append(')');
        String signature = signatureBuilder.toString();
        return signature;
    }

    public static String getFileNameStart(String kiekerPattern) {
        String separator = File.separator;
        String fileNameStart = KiekerPatternConverter.convertPattern(kiekerPattern, separator);
        return fileNameStart;
    }

    public static String getKey(String kiekerPattern) {
        String separator = ".";
        String fileNameStart = KiekerPatternConverter.convertPattern(kiekerPattern, ".");
        return fileNameStart;
    }

    private static String convertPattern(String kiekerPattern, String separator) {
        String call = kiekerPattern.substring(kiekerPattern.lastIndexOf(32) + 1, kiekerPattern.lastIndexOf(40));
        int dotIndex = call.lastIndexOf(".");
        String method = call.substring(dotIndex + 1);
        String clazz = call.substring(0, dotIndex);
        String parameterString = KiekerPatternConverter.getParameterKeyString(kiekerPattern);
        String fileNameStart = clazz + separator + method + "_" + parameterString;
        return fileNameStart;
    }

    public static String getParameterKeyString(String kiekerPattern) {
        String parameters = kiekerPattern.substring(kiekerPattern.lastIndexOf(40) + 1, kiekerPattern.length() - 1);
        Object parameterString = "";
        for (String parameter : parameters.split(",")) {
            int index = parameter.lastIndexOf(46);
            parameterString = (String)parameterString + (index != -1 ? parameter.substring(index + 1) : parameter) + "_";
        }
        parameterString = ((String)parameterString).substring(0, ((String)parameterString).length() - 1);
        return parameterString;
    }
}

