/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.kieker;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.dagere.kopeme.kieker.aggregateddata.AggregatedData;
import de.dagere.kopeme.kieker.aggregateddata.AggregatedDataNode;
import de.dagere.kopeme.kieker.writer.AggregatedDataReader;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.dependency.traces.KiekerFolderUtil;
import de.dagere.peass.measurement.rca.RCAStrategy;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.kieker.KiekerPatternConverter;
import de.dagere.peass.measurement.rca.kiekerReading.KiekerDurationReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import kieker.analysis.exception.AnalysisConfigurationException;
import net.kieker.sourceinstrumentation.AllowedKiekerRecord;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KiekerResultReader {
    private static final Logger LOG = LogManager.getLogger(KiekerResultReader.class);
    final boolean useAggregation;
    private final RCAStrategy strategy;
    private final AllowedKiekerRecord usedRecord;
    private final Set<CallTreeNode> includedNodes;
    final String commit;
    final TestMethodCall testcase;
    final boolean otherCommit;
    boolean considerNodePosition = false;

    public KiekerResultReader(boolean useAggregation, AllowedKiekerRecord usedRecord, RCAStrategy strategy, Set<CallTreeNode> includedNodes, String commit, TestMethodCall testcase, boolean otherCommit) {
        this.useAggregation = useAggregation;
        this.strategy = strategy;
        this.usedRecord = usedRecord;
        this.includedNodes = includedNodes;
        this.commit = commit;
        this.testcase = testcase;
        this.otherCommit = otherCommit;
    }

    public void setConsiderNodePosition(boolean considerNodePosition) {
        this.considerNodePosition = considerNodePosition;
    }

    public void readResults(File commitResultFolder) {
        try {
            File[] kiekerResultFiles;
            LOG.info("Reading kieker results from {}", (Object)commitResultFolder.getAbsolutePath(), (Object)this.commit);
            OrFileFilter filter = new OrFileFilter((IOFileFilter)new RegexFileFilter("[0-9]*"), (IOFileFilter)new RegexFileFilter("measurement-[0-9]*.csv"));
            for (File kiekerResultFolder : kiekerResultFiles = commitResultFolder.listFiles((FileFilter)filter)) {
                File kiekerTraceFile = KiekerFolderUtil.getKiekerTraceFolder((File)kiekerResultFolder, (TestMethodCall)this.testcase);
                LOG.debug("Reading file: {}", (Object)kiekerTraceFile.getAbsolutePath());
                if (this.useAggregation) {
                    this.readAggregatedData(kiekerTraceFile);
                    continue;
                }
                this.readNonAggregated(kiekerTraceFile);
            }
        }
        catch (IOException | IllegalStateException | AnalysisConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void readAggregatedData(File kiekerTraceFolder) throws JsonParseException, JsonMappingException, IOException {
        Map fullDataMap = AggregatedDataReader.getFullDataMap((File)kiekerTraceFolder);
        if (fullDataMap.isEmpty()) {
            LOG.warn("No data were measured - a measurement error occured");
        } else {
            for (CallTreeNode node : this.includedNodes) {
                this.readNode(fullDataMap, node);
            }
        }
    }

    private void readNode(Map<AggregatedDataNode, AggregatedData> fullDataMap, CallTreeNode node) {
        boolean nodeFound = false;
        CallTreeNode examinedNode = this.otherCommit ? node.getOtherCommitNode() : node;
        LinkedList<StatisticalSummary> values = new LinkedList<StatisticalSummary>();
        for (Map.Entry<AggregatedDataNode, AggregatedData> entry : fullDataMap.entrySet()) {
            if (!this.isSameNode(examinedNode, entry.getKey())) continue;
            for (StatisticalSummary dataSlice : entry.getValue().getStatistic().values()) {
                values.add(dataSlice);
            }
            nodeFound = true;
        }
        if (nodeFound) {
            LOG.debug("Setting measurement: {} {} Values: {}", (Object)this.commit, (Object)node.getKiekerPattern(), (Object)values.size());
            node.addAggregatedMeasurement(this.commit, values);
        } else {
            LOG.warn("Node {} ({}) did not find measurement values, measured methods: {}", (Object)node.getKiekerPattern(), (Object)node.getOtherKiekerPattern(), (Object)fullDataMap.entrySet().size());
        }
    }

    private boolean isSameNode(CallTreeNode node, AggregatedDataNode measuredNode) {
        String nodeCall = KiekerPatternConverter.fixParameters(node.getKiekerPattern());
        String kiekerCall = KiekerPatternConverter.getKiekerPattern(measuredNode.getCall());
        LOG.trace("Node: {} Kieker: {} Equal: {}", (Object)nodeCall, (Object)kiekerCall, (Object)nodeCall.equals(kiekerCall));
        if (nodeCall.equals(kiekerCall) || node.getParent() == null && this.isSameNodeWithoutModifier(nodeCall, kiekerCall)) {
            LOG.trace("EOI: {} vs {}", (Object)node.getEoi(this.commit), (Object)measuredNode.getEoi());
            if (this.considerNodePosition) {
                int eoi = node.getEoi(this.commit);
                return measuredNode.getEoi() == eoi;
            }
            return true;
        }
        return false;
    }

    public void readNonAggregated(File kiekerTraceFolder) throws AnalysisConfigurationException {
        if (this.usedRecord == AllowedKiekerRecord.OPERATIONEXECUTION && this.strategy != RCAStrategy.UNTIL_SOURCE_CHANGE) {
            KiekerDurationReader.executeDurationStage(kiekerTraceFolder, this.includedNodes, this.commit);
        } else if (this.usedRecord == AllowedKiekerRecord.OPERATIONEXECUTION && this.strategy == RCAStrategy.UNTIL_SOURCE_CHANGE) {
            KiekerDurationReader.executeUSCDurationStage(kiekerTraceFolder, this.includedNodes, this.commit);
        } else if (this.usedRecord == AllowedKiekerRecord.DURATION) {
            KiekerDurationReader.executeReducedDurationStage(kiekerTraceFolder, this.includedNodes, this.commit);
        }
    }

    private boolean isSameNodeWithoutModifier(String nodeCall, String kiekerCall) {
        if ("ADDED".equals(nodeCall)) {
            return false;
        }
        String executable = this.testcase.getExecutable().replace("#", ".");
        String pureCall = nodeCall.substring("public ".length());
        return nodeCall.contains(executable) && pureCall.equals(kiekerCall);
    }
}

