/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.kieker;

import de.dagere.nodeDiffDetector.data.TestCase;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.KiekerResultManager;
import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.traces.KiekerFolderUtil;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.kieker.TreeStage;
import de.dagere.peass.measurement.rca.kiekerReading.KiekerDurationReader;
import java.io.File;
import net.kieker.sourceinstrumentation.AllowedKiekerRecord;

public class TreeReader
extends KiekerResultManager {
    private boolean ignoreEOIs = true;
    private final MeasurementConfig realConfig;

    TreeReader(PeassFolders folders, MeasurementConfig config, EnvironmentVariables env) {
        super(folders, config.getExecutionConfig(), config.getKiekerConfig(), env);
        this.testTransformer.getConfig().getKiekerConfig().setUseKieker(true);
        this.testTransformer.getConfig().getKiekerConfig().setUseAggregation(false);
        this.testTransformer.getConfig().getKiekerConfig().setRecord(AllowedKiekerRecord.OPERATIONEXECUTION);
        this.realConfig = config;
    }

    public void setIgnoreEOIs(boolean ignoreEOIs) {
        this.ignoreEOIs = ignoreEOIs;
    }

    public CallTreeNode getTree(TestMethodCall testcase, String commit) {
        this.executeMeasurements(testcase, commit);
        File resultsFolder = KiekerFolderUtil.getModuleResultFolder((PeassFolders)this.folders, (TestCase)testcase);
        File kiekerTraceFolder = KiekerFolderUtil.getClazzMethodFolder((TestMethodCall)testcase, (File)resultsFolder)[0];
        CallTreeNode root = this.readTree(testcase, kiekerTraceFolder);
        return root;
    }

    private CallTreeNode readTree(TestMethodCall testcase, File kiekerTraceFolder) {
        ModuleClassMapping mapping = new ModuleClassMapping(this.folders.getProjectFolder(), this.executor.getModules(), this.realConfig.getExecutionConfig());
        TreeStage stage = KiekerDurationReader.executeTreeStage(kiekerTraceFolder, testcase, this.ignoreEOIs, this.realConfig, mapping);
        CallTreeNode root = stage.getRoot();
        if (root == null) {
            throw new RuntimeException("An error occured - root node of " + String.valueOf(testcase) + " could not be identified!");
        }
        return root;
    }

    private void executeMeasurements(TestMethodCall testcase, String commit) {
        this.executor.loadClasses();
        this.executeKoPeMeKiekerRun(new TestSet(testcase), commit, this.folders.getTreeLogFolder());
    }
}

