/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.kieker;

import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.nodeDiffDetector.typeFinding.TypeFileFinder;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.analysis.ModuleClassMapping;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.kieker.KiekerPatternConverter;
import kieker.analysis.architecture.trace.AbstractTraceProcessingStage;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.Execution;
import kieker.model.system.model.ExecutionTrace;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TreeStage
extends AbstractTraceProcessingStage<ExecutionTrace> {
    private static final Logger LOG = LogManager.getLogger(TreeStage.class);
    private CallTreeNode root;
    private MeasurementConfig measurementConfig;
    private final TestMethodCall test;
    private final boolean ignoreEOIs;
    private final ModuleClassMapping mapping;
    private CallTreeNode lastParent = null;
    private CallTreeNode lastAdded = null;
    private int lastStackSize = 1;
    private long testTraceId = -1L;

    public TreeStage(SystemModelRepository systemModelRepository, TestMethodCall test, boolean ignoreEOIs, MeasurementConfig config, ModuleClassMapping mapping) {
        super(systemModelRepository);
        this.test = test;
        this.measurementConfig = config;
        this.ignoreEOIs = ignoreEOIs;
        this.mapping = mapping;
    }

    public CallTreeNode getRoot() {
        return this.root;
    }

    protected void execute(ExecutionTrace trace) throws Exception {
        LOG.info("Trace: " + trace.getTraceId());
        for (Execution execution : trace.getTraceAsSortedExecutionSet()) {
            String fullClassname = execution.getOperation().getComponentType().getFullQualifiedName().intern();
            String methodname = execution.getOperation().getSignature().getName().intern();
            String call = fullClassname + "#" + methodname;
            String kiekerPattern = KiekerPatternConverter.getKiekerPattern(execution.getOperation());
            LOG.trace("{} {}", (Object)kiekerPattern, (Object)execution.getEss());
            if (methodname.equals("class$") || methodname.startsWith("access$")) continue;
            this.addExecutionToTree(execution, fullClassname, methodname, call, kiekerPattern);
        }
    }

    private void addExecutionToTree(Execution execution, String fullClassname, String methodname, String call, String kiekerPattern) {
        if (this.test.getClazz().equals(fullClassname) && this.test.getMethod().equals(methodname)) {
            this.readRoot(execution, call, kiekerPattern);
            this.setModule(fullClassname, this.root);
        } else if (this.root != null && execution.getTraceId() == this.testTraceId) {
            LOG.trace(fullClassname + " " + String.valueOf(execution.getOperation().getSignature()) + " " + execution.getEoi() + " " + execution.getEss());
            LOG.trace("Last Stack: " + this.lastStackSize);
            this.callLevelDown(execution);
            this.callLevelUp(execution);
            LOG.trace("Parent: {} {}", (Object)this.lastParent.getCall(), (Object)this.lastParent.getEss());
            if (execution.getEss() == this.lastParent.getEss()) {
                String message = "Trying to add " + call + "(" + execution.getEss() + ") to " + this.lastParent.getCall() + "(" + this.lastParent.getEss() + "), but parent ess always needs to be child ess -1";
                LOG.error(message);
                throw new RuntimeException(message);
            }
            boolean hasEqualNode = false;
            for (CallTreeNode candidate : this.lastParent.getChildren()) {
                if (!candidate.getKiekerPattern().equals(kiekerPattern)) continue;
                hasEqualNode = true;
                this.lastAdded = candidate;
            }
            if (!this.ignoreEOIs || !hasEqualNode) {
                this.lastAdded = this.lastParent.appendChild(call, kiekerPattern, null);
                this.setModule(fullClassname, this.lastAdded);
            }
        }
    }

    private void setModule(String fullClassname, CallTreeNode node) {
        String outerClazzName = TypeFileFinder.getOuterClass((String)fullClassname);
        String moduleOfClass = this.mapping.getModuleOfClass(outerClazzName);
        node.setModule(moduleOfClass);
    }

    private void callLevelUp(Execution execution) {
        while (execution.getEss() < this.lastStackSize) {
            LOG.trace("Level up: " + execution.getEss() + " " + this.lastStackSize);
            this.lastParent = this.lastParent.getParent();
            --this.lastStackSize;
        }
    }

    private void callLevelDown(Execution execution) {
        if (execution.getEss() > this.lastStackSize) {
            LOG.trace("Level down: " + execution.getEss() + " " + this.lastStackSize);
            this.lastParent = this.lastAdded;
            if (this.lastStackSize + 1 != this.lastParent.getEss() + 1) {
                LOG.error("Down caused wrong lastStackSize: {} {}", (Object)this.lastStackSize, (Object)this.lastParent.getEss());
            }
            this.lastStackSize = this.lastParent.getEss() + 1;
            LOG.trace("Stack size after going down: {} Measured: {}", (Object)this.lastParent.getEss(), (Object)this.lastStackSize);
        }
    }

    private void readRoot(Execution execution, String call, String kiekerPattern) {
        this.root = kiekerPattern.startsWith("public ") ? new CallTreeNode(call, kiekerPattern, null, this.measurementConfig) : new CallTreeNode(call, "public " + kiekerPattern, null, this.measurementConfig);
        this.lastParent = this.root;
        this.testTraceId = execution.getTraceId();
    }
}

