/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.kiekerReading;

import de.dagere.kopeme.kieker.record.DurationRecord;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.kieker.KiekerPatternConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kieker.analysis.architecture.trace.AbstractTraceAnalysisStage;
import kieker.model.repository.SystemModelRepository;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DurationRCAStage
extends AbstractTraceAnalysisStage<DurationRecord> {
    private static final Logger LOG = LogManager.getLogger(DurationRCAStage.class);
    private final Map<String, CallTreeNode> measuredNodes = new HashMap<String, CallTreeNode>();
    private final String commit;

    public DurationRCAStage(SystemModelRepository systemModelRepository, Set<CallTreeNode> measuredNodes, String commit) {
        super(systemModelRepository);
        for (CallTreeNode node2 : measuredNodes) {
            this.measuredNodes.put(node2.getKiekerPattern(), node2);
        }
        this.commit = commit;
        measuredNodes.forEach(node -> node.initVMData(commit));
    }

    protected void execute(DurationRecord execution) throws Exception {
        String kiekerPattern = KiekerPatternConverter.addNewIfRequired(execution.getOperationSignature());
        CallTreeNode node = this.measuredNodes.get(kiekerPattern);
        if (node != null) {
            long duration = execution.getTout() - execution.getTin();
            node.addMeasurement(this.commit, duration);
        }
    }
}

