/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.kiekerReading;

import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.kieker.KiekerPatternConverter;
import de.dagere.peass.measurement.rca.kiekerReading.EOIESSIndex;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kieker.analysis.architecture.trace.AbstractTraceProcessingStage;
import kieker.model.repository.SystemModelRepository;
import kieker.model.system.model.Execution;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OperationExecutionRCAStage
extends AbstractTraceProcessingStage<Execution> {
    private static final Logger LOG = LogManager.getLogger(OperationExecutionRCAStage.class);
    private final Map<EOIESSIndex, CallTreeNode> measuredNodes = new HashMap<EOIESSIndex, CallTreeNode>();
    private final String commit;

    public OperationExecutionRCAStage(SystemModelRepository systemModelRepository, Set<CallTreeNode> measuredNodes, String commit) {
        super(systemModelRepository);
        for (CallTreeNode node2 : measuredNodes) {
            int eoi = node2.getEoi(commit);
            int ess = node2.getEss();
            String currentPattern = node2.getConfig().getFixedCommitConfig().getCommitOld().equals(commit) ? node2.getKiekerPattern() : node2.getOtherKiekerPattern();
            EOIESSIndex index = new EOIESSIndex(ess, eoi, currentPattern);
            this.measuredNodes.put(index, node2);
        }
        this.commit = commit;
        measuredNodes.forEach(node -> node.initVMData(commit));
    }

    protected void execute(Execution execution) throws Exception {
        LOG.trace("Trace: {}", (Object)execution.getTraceId());
        this.addMeasurements(execution);
    }

    private void addMeasurements(Execution execution) {
        String kiekerPattern = KiekerPatternConverter.getKiekerPattern(execution.getOperation());
        EOIESSIndex lookupindex = new EOIESSIndex(execution.getEss(), execution.getEoi(), kiekerPattern);
        CallTreeNode node = this.measuredNodes.get(lookupindex);
        if (node != null) {
            long duration = execution.getTout() - execution.getTin();
            node.addMeasurement(this.commit, duration);
        } else {
            LOG.error("Did not find {} Eoi: {} ESS: {} ", (Object)kiekerPattern, (Object)execution.getEoi(), (Object)execution.getEss());
            LOG.info("Nodes: " + String.valueOf(this.measuredNodes.keySet()));
        }
    }
}

