/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.searcher;

import de.dagere.nodeDiffDetector.data.MethodCall;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.CauseSearchFolders;
import de.dagere.peass.measurement.rca.CausePersistenceManager;
import de.dagere.peass.measurement.rca.CauseSearcherConfig;
import de.dagere.peass.measurement.rca.CauseTester;
import de.dagere.peass.measurement.rca.RCAMeasurementAdder;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.data.CauseSearchData;
import de.dagere.peass.measurement.rca.kieker.BothTreeReader;
import de.dagere.peass.measurement.rca.searcher.ICauseSearcher;
import de.dagere.peass.measurement.rca.treeanalysis.AllDifferingDeterminer;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CauseSearcher
implements ICauseSearcher {
    private static final Logger LOG = LogManager.getLogger(CauseSearcher.class);
    protected final CauseSearchFolders folders;
    protected final CauseSearcherConfig causeSearchConfig;
    protected final MeasurementConfig measurementConfig;
    protected final EnvironmentVariables env;
    protected final BothTreeReader reader;
    protected final CauseTester measurer;
    protected List<CallTreeNode> differingNodes = new LinkedList<CallTreeNode>();
    protected CausePersistenceManager persistenceManager;

    public CauseSearcher(BothTreeReader reader, CauseSearcherConfig causeSearchConfig, CauseTester measurer, MeasurementConfig measurementConfig, CauseSearchFolders folders, EnvironmentVariables env) {
        this.reader = reader;
        this.measurer = measurer;
        this.measurementConfig = measurementConfig;
        this.folders = folders;
        this.causeSearchConfig = causeSearchConfig;
        this.env = env;
    }

    @Override
    public Set<MethodCall> search() {
        this.reader.readTrees();
        LOG.info("Tree size: {}", (Object)this.reader.getRootPredecessor().getTreeSize());
        return this.searchCause();
    }

    protected abstract Set<MethodCall> searchCause();

    protected Set<MethodCall> convertToChangedEntitites() {
        TreeSet<MethodCall> changed = new TreeSet<MethodCall>();
        this.differingNodes.forEach(node -> changed.add(node.toEntity()));
        return changed;
    }

    protected void measureDefinedTree(List<CallTreeNode> includableNodes) {
        AllDifferingDeterminer allSearcher = new AllDifferingDeterminer(includableNodes, this.causeSearchConfig, this.measurementConfig);
        this.measurer.measureCommit(includableNodes);
        allSearcher.calculateDiffering();
        RCAMeasurementAdder measurementReader = new RCAMeasurementAdder(this.persistenceManager, includableNodes);
        measurementReader.addAllMeasurements(this.reader.getRootPredecessor());
        this.differingNodes.addAll(allSearcher.getLevelDifferentPredecessor());
        this.writeTreeState();
    }

    protected void writeTreeState() {
        this.persistenceManager.writeTreeState();
    }

    public CauseSearchData getRCAData() {
        return this.persistenceManager.getRCAData();
    }
}

