/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.searcher;

import de.dagere.nodeDiffDetector.data.MethodCall;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.CauseSearchFolders;
import de.dagere.peass.measurement.rca.CausePersistenceManager;
import de.dagere.peass.measurement.rca.CauseSearcherConfig;
import de.dagere.peass.measurement.rca.CauseTester;
import de.dagere.peass.measurement.rca.analyzer.CompleteTreeAnalyzer;
import de.dagere.peass.measurement.rca.analyzer.TreeAnalyzer;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.kieker.BothTreeReader;
import de.dagere.peass.measurement.rca.searcher.CauseSearcher;
import de.dagere.peass.measurement.rca.searcher.TreeAnalyzerCreator;
import de.dagere.peass.measurement.rca.treeanalysis.AllDifferingDeterminer;
import de.dagere.peass.vcs.GitUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CauseSearcherComplete
extends CauseSearcher {
    private static final Logger LOG = LogManager.getLogger(CauseSearcherComplete.class);
    private final TreeAnalyzerCreator creator;

    public CauseSearcherComplete(BothTreeReader reader, CauseSearcherConfig causeSearchConfig, CauseTester measurer, MeasurementConfig measurementConfig, CauseSearchFolders folders, EnvironmentVariables env) throws InterruptedException, IOException {
        super(reader, causeSearchConfig, measurer, measurementConfig, folders, env);
        this.persistenceManager = new CausePersistenceManager(causeSearchConfig, measurementConfig, folders);
        this.checkConfiguration(causeSearchConfig, measurementConfig);
        this.creator = new TreeAnalyzerCreator(){

            @Override
            public TreeAnalyzer getAnalyzer(BothTreeReader reader, CauseSearcherConfig config) {
                return new CompleteTreeAnalyzer(reader.getRootCurrent(), reader.getRootPredecessor());
            }
        };
    }

    public CauseSearcherComplete(BothTreeReader reader, CauseSearcherConfig causeSearchConfig, CauseTester measurer, MeasurementConfig measurementConfig, CauseSearchFolders folders, TreeAnalyzerCreator creator, EnvironmentVariables env) throws InterruptedException, IOException {
        super(reader, causeSearchConfig, measurer, measurementConfig, folders, env);
        this.persistenceManager = new CausePersistenceManager(causeSearchConfig, measurementConfig, folders);
        this.creator = creator;
        this.checkConfiguration(causeSearchConfig, measurementConfig);
    }

    private void checkConfiguration(CauseSearcherConfig causeSearchConfig, MeasurementConfig measurementConfig) {
        if (measurementConfig.getKiekerConfig().isUseAggregation() && !causeSearchConfig.isIgnoreEOIs()) {
            throw new RuntimeException("Aggregation and ignoreEOIs cannot be combined; if aggregation is enabled, ignoreEOIs needs to be enabled.");
        }
        if (!measurementConfig.getKiekerConfig().isUseAggregation() && causeSearchConfig.isIgnoreEOIs()) {
            throw new RuntimeException("No aggregation and ignoreEOIs can currently be not combined, since this would require mapping of the original measured tree data to the ignore-EOI tree. Currently, only aggregation + ignoreEOI both activated or both deactivated is possible. In the future, no aggregation and ignoreEOIs might become possible.");
        }
    }

    @Override
    protected Set<MethodCall> searchCause() {
        TreeAnalyzer analyzer = this.creator.getAnalyzer(this.reader, this.causeSearchConfig);
        List<CallTreeNode> predecessorNodeList = analyzer.getMeasurementNodesPredecessor();
        List<CallTreeNode> includableNodes = this.getIncludableNodes(predecessorNodeList);
        if (includableNodes.isEmpty()) {
            throw new RuntimeException("Tried to analyze empty node list");
        }
        this.measureDefinedTree(includableNodes);
        return this.convertToChangedEntitites();
    }

    private List<CallTreeNode> getIncludableNodes(List<CallTreeNode> predecessorNodeList) {
        List<CallTreeNode> includableNodes = this.causeSearchConfig.useCalibrationRun() ? this.getAnalysableNodes(predecessorNodeList) : predecessorNodeList;
        LOG.debug("Analyzable: {} / {}", (Object)includableNodes.size(), (Object)predecessorNodeList.size());
        return includableNodes;
    }

    private List<CallTreeNode> getAnalysableNodes(List<CallTreeNode> predecessorNodeList) {
        MeasurementConfig config = new MeasurementConfig(1, this.measurementConfig.getFixedCommitConfig().getCommit(), this.measurementConfig.getFixedCommitConfig().getCommitOld());
        config.setIterations(this.measurementConfig.getIterations());
        config.setRepetitions(this.measurementConfig.getRepetitions());
        config.setWarmup(this.measurementConfig.getWarmup());
        config.getKiekerConfig().setUseKieker(true);
        List commits = GitUtils.getCommits((File)this.folders.getProjectFolder(), (boolean)true, (boolean)true);
        CommitComparatorInstance comparator = new CommitComparatorInstance(commits);
        CauseTester calibrationMeasurer = new CauseTester(this.folders, config, this.causeSearchConfig, this.env, comparator);
        AllDifferingDeterminer calibrationRunner = new AllDifferingDeterminer(predecessorNodeList, this.causeSearchConfig, config);
        calibrationMeasurer.measureCommit(predecessorNodeList);
        List<CallTreeNode> includableByMinTime = calibrationRunner.getIncludableNodes();
        return includableByMinTime;
    }
}

