/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.searcher;

import de.dagere.nodeDiffDetector.data.MethodCall;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.folders.CauseSearchFolders;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.measurement.organize.FolderDeterminer;
import de.dagere.peass.measurement.rca.CausePersistenceManager;
import de.dagere.peass.measurement.rca.CauseSearcherConfig;
import de.dagere.peass.measurement.rca.CauseTester;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.kieker.BothTreeReader;
import de.dagere.peass.measurement.rca.searcher.CauseSearcher;
import de.dagere.peass.measurement.rca.searcher.LevelChildDeterminer;
import de.dagere.peass.measurement.rca.treeanalysis.LevelDifferentNodeDeterminer;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LevelCauseSearcher
extends CauseSearcher {
    private static final Logger LOG = LogManager.getLogger(LevelCauseSearcher.class);

    public LevelCauseSearcher(CauseTester measurer, CausePersistenceManager persistenceManager, EnvironmentVariables env) {
        super(null, persistenceManager.getRCAData().getCauseConfig(), measurer, persistenceManager.getRCAData().getMeasurementConfig(), persistenceManager.getFolders(), env);
        this.persistenceManager = persistenceManager;
    }

    public LevelCauseSearcher(BothTreeReader reader, CauseSearcherConfig causeSearchConfig, CauseTester measurer, MeasurementConfig measurementConfig, CauseSearchFolders folders, EnvironmentVariables env) {
        super(reader, causeSearchConfig, measurer, measurementConfig, folders, env);
        this.persistenceManager = new CausePersistenceManager(causeSearchConfig, measurementConfig, folders);
        File potentialOldFolder = new File(folders.getArchiveResultFolder(measurementConfig.getFixedCommitConfig().getCommit(), causeSearchConfig.getTestCase()), "0");
        if (potentialOldFolder.exists()) {
            throw new RuntimeException("Old measurement folder " + potentialOldFolder.getAbsolutePath() + " exists - please cleanup!");
        }
        new FolderDeterminer((PeassFolders)folders).testResultFolders(measurementConfig.getFixedCommitConfig().getCommit(), measurementConfig.getFixedCommitConfig().getCommitOld(), causeSearchConfig.getTestCase());
    }

    @Override
    protected Set<MethodCall> searchCause() {
        this.reader.getRootPredecessor().setOtherCommitNode(this.reader.getRootCurrent());
        this.reader.getRootCurrent().setOtherCommitNode(this.reader.getRootPredecessor());
        this.reader.getRootPredecessor().setOtherKiekerPattern(this.reader.getRootCurrent().getKiekerPattern());
        LevelChildDeterminer predecessorDeterminer = new LevelChildDeterminer(Arrays.asList(this.reader.getRootPredecessor()), this.causeSearchConfig.getLevels() - 1);
        List<CallTreeNode> initialNodesPredecessor = predecessorDeterminer.getSelectedIncludingParentNodes();
        LevelChildDeterminer currentDeterminer = new LevelChildDeterminer(Arrays.asList(this.reader.getRootCurrent()), this.causeSearchConfig.getLevels() - 1);
        List<CallTreeNode> initialNodesCurrent = currentDeterminer.getSelectedIncludingParentNodes();
        this.isLevelDifferent(initialNodesPredecessor, initialNodesCurrent);
        return this.convertToChangedEntitites();
    }

    public void isLevelDifferent(List<CallTreeNode> currentPredecessorNodeList, List<CallTreeNode> currentVersionNodeList) {
        LevelDifferentNodeDeterminer levelDifferentNodeDeterminer = new LevelDifferentNodeDeterminer(currentPredecessorNodeList, currentVersionNodeList, this.causeSearchConfig, this.measurementConfig);
        List<CallTreeNode> measurePredecessor = levelDifferentNodeDeterminer.getMeasurePredecessor();
        LOG.info("Measure next level: {}", measurePredecessor);
        if (measurePredecessor.size() > 0) {
            this.measureLevel(levelDifferentNodeDeterminer, measurePredecessor);
            this.writeTreeState();
            List<CallTreeNode> differentNodesPredecessor = LevelChildDeterminer.filterDeepestLevel(levelDifferentNodeDeterminer.getLevelDifferentPredecessor());
            List<CallTreeNode> measureChildsPredecessor = LevelChildDeterminer.getLevelChilds(differentNodesPredecessor, this.causeSearchConfig.getLevels());
            List<CallTreeNode> differentNodesCurrent = LevelChildDeterminer.filterDeepestLevel(levelDifferentNodeDeterminer.getLevelDifferentCurrent());
            List<CallTreeNode> measureChildsCurrent = LevelChildDeterminer.getLevelChilds(differentNodesCurrent, this.causeSearchConfig.getLevels());
            LOG.debug("Different nodes: {} {}", differentNodesPredecessor, differentNodesCurrent);
            LOG.debug("Nodes for remeasurement: {} {}", measureChildsPredecessor, measureChildsCurrent);
            this.isLevelDifferent(measureChildsPredecessor, measureChildsCurrent);
        }
    }

    private void measureLevel(LevelDifferentNodeDeterminer levelDifferentNodeDeterminer, List<CallTreeNode> measuredPredecessor) {
        this.measurer.measureCommit(measuredPredecessor);
        levelDifferentNodeDeterminer.calculateDiffering();
        for (CallTreeNode predecessorNode : measuredPredecessor) {
            this.persistenceManager.addMeasurement(predecessorNode);
        }
        this.differingNodes.addAll(levelDifferentNodeDeterminer.getTreeStructureDifferingNodes());
        this.differingNodes.addAll(levelDifferentNodeDeterminer.getLevelDifferentPredecessor());
    }
}

