/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.searcher;

import de.dagere.peass.measurement.rca.data.CallTreeNode;
import java.util.LinkedList;
import java.util.List;

public class LevelChildDeterminer {
    public List<CallTreeNode> initialNodes;
    public List<CallTreeNode> selectedNodes = new LinkedList<CallTreeNode>();

    public LevelChildDeterminer(List<CallTreeNode> initialNodes, int levels) {
        this.initialNodes = initialNodes;
        this.selectedNodes.addAll(initialNodes);
        LinkedList<CallTreeNode> iterationNodes = new LinkedList<CallTreeNode>(initialNodes);
        for (int level = 0; level < levels; ++level) {
            LinkedList<CallTreeNode> childs = new LinkedList<CallTreeNode>();
            for (CallTreeNode parent : iterationNodes) {
                childs.addAll(parent.getChildren());
            }
            this.selectedNodes.addAll(childs);
            iterationNodes = childs;
        }
    }

    public List<CallTreeNode> getSelectedIncludingParentNodes() {
        return this.selectedNodes;
    }

    public List<CallTreeNode> getOnlyChildNodes() {
        LinkedList<CallTreeNode> childNodes = new LinkedList<CallTreeNode>(this.selectedNodes);
        childNodes.removeAll(this.initialNodes);
        return childNodes;
    }

    public static List<CallTreeNode> getLevelChilds(List<CallTreeNode> levelNodes, int levels) {
        return new LevelChildDeterminer(levelNodes, levels).getOnlyChildNodes();
    }

    public static List<CallTreeNode> filterDeepestLevel(List<CallTreeNode> input) {
        int maxLevel = 0;
        for (CallTreeNode node : input) {
            if (node.getEss() <= maxLevel) continue;
            maxLevel = node.getEss();
        }
        LinkedList<CallTreeNode> result = new LinkedList<CallTreeNode>();
        for (CallTreeNode node : input) {
            if (node.getEss() != maxLevel) continue;
            result.add(node);
        }
        return result;
    }
}

