/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.searcher;

import de.dagere.nodeDiffDetector.data.MethodCall;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.ExecutionConfig;
import de.dagere.peass.config.FixedCommitConfig;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.config.MeasurementStrategy;
import de.dagere.peass.dependency.ExecutorCreator;
import de.dagere.peass.execution.processutils.ProcessBuilderHelper;
import de.dagere.peass.execution.utils.EnvironmentVariables;
import de.dagere.peass.execution.utils.TestExecutor;
import de.dagere.peass.folders.PeassFolders;
import de.dagere.peass.measurement.dependencyprocessors.SamplingRunner;
import de.dagere.peass.measurement.dependencyprocessors.helper.ProgressWriter;
import de.dagere.peass.measurement.organize.FolderDeterminer;
import de.dagere.peass.measurement.organize.ResultOrganizer;
import de.dagere.peass.measurement.rca.searcher.ICauseSearcher;
import de.dagere.peass.testtransformation.TestTransformer;
import java.io.File;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SamplingCauseSearcher
implements ICauseSearcher {
    private static final Logger LOG = LogManager.getLogger(SamplingCauseSearcher.class);
    private final TestMethodCall testcase;
    protected final MeasurementConfig configuration;
    protected final PeassFolders folders;
    private ResultOrganizer currentOrganizer;
    protected final EnvironmentVariables env;
    protected long currentChunkStart = 0L;

    public SamplingCauseSearcher(TestMethodCall testcase, MeasurementConfig configuration, PeassFolders folders, EnvironmentVariables env) {
        this.testcase = testcase;
        this.configuration = configuration;
        this.folders = folders;
        this.env = env;
    }

    @Override
    public Set<MethodCall> search() {
        FixedCommitConfig fixedCommitConfig = this.configuration.getFixedCommitConfig();
        LOG.info("Executing test " + this.testcase.getClazz() + " " + this.testcase.getMethod() + " in commits {} and {}", (Object)fixedCommitConfig.getCommitOld(), (Object)fixedCommitConfig.getCommit());
        new FolderDeterminer(this.folders).testResultFolders(fixedCommitConfig.getCommit(), fixedCommitConfig.getCommitOld(), this.testcase);
        File logFolder = this.folders.getMeasureLogFolder(this.configuration.getFixedCommitConfig().getCommit(), this.testcase);
        try (ProgressWriter writer = new ProgressWriter(this.folders.getProgressFile(), this.configuration.getVms());){
            this.evaluateSimple(this.testcase, logFolder, writer);
        }
        throw new RuntimeException("Not implemented yet");
    }

    private void evaluateSimple(TestMethodCall testcase2, File logFolder, ProgressWriter writer) {
        this.currentChunkStart = System.currentTimeMillis();
        for (int finishedVMs = 0; finishedVMs < this.configuration.getVms(); ++finishedVMs) {
            long comparisonStart = System.currentTimeMillis();
            this.runOneComparison(logFolder, this.testcase, finishedVMs);
            long durationInSeconds = (System.currentTimeMillis() - comparisonStart) / 1000L;
            writer.write(durationInSeconds, finishedVMs);
            this.betweenVMCooldown();
        }
    }

    public void runOneComparison(File logFolder, TestMethodCall testcase, int vmid) {
        String[] commits = this.getVersions();
        if (this.configuration.getMeasurementStrategy().equals((Object)MeasurementStrategy.SEQUENTIAL)) {
            LOG.info("Running sequential");
            this.runSequential(logFolder, testcase, vmid, commits);
        } else if (this.configuration.getMeasurementStrategy().equals((Object)MeasurementStrategy.PARALLEL)) {
            LOG.info("Running parallel");
            this.runParallel(logFolder, testcase, vmid, commits);
        }
    }

    private void runParallel(File logFolder, TestMethodCall testcase2, int vmid, String[] commits) {
        throw new RuntimeException("Not implemented yet");
    }

    private void runSequential(File logFolder, TestMethodCall testcase2, int vmid, String[] commits) {
        this.currentOrganizer = new ResultOrganizer(this.folders, this.configuration.getFixedCommitConfig().getCommit(), this.currentChunkStart, this.configuration.getKiekerConfig().isUseKieker(), this.configuration.isSaveAll(), this.testcase, this.configuration.getAllIterations());
        for (String commit : commits) {
            this.runOnce(this.testcase, commit, vmid, logFolder);
        }
    }

    private void runOnce(TestMethodCall testcase, String commit, int vmid, File logFolder) {
        TestExecutor testExecutor = this.getExecutor(this.folders, commit);
        SamplingRunner runner = new SamplingRunner(this.folders, testExecutor, this.getCurrentOrganizer(), this);
        runner.runOnce(testcase, commit, vmid, logFolder);
    }

    protected synchronized TestExecutor getExecutor(PeassFolders currentFolders, String commit) {
        TestTransformer transformer = ExecutorCreator.createTestTransformer((PeassFolders)currentFolders, (ExecutionConfig)this.configuration.getExecutionConfig(), (MeasurementConfig)this.configuration);
        TestExecutor testExecutor = ExecutorCreator.createExecutor((PeassFolders)currentFolders, (TestTransformer)transformer, (EnvironmentVariables)this.env);
        return testExecutor;
    }

    protected void betweenVMCooldown() {
        if (this.configuration.isCallSyncBetweenVMs()) {
            ProcessBuilderHelper.syncToHdd();
        }
        try {
            Thread.sleep(this.configuration.getWaitTimeBetweenVMs());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public ResultOrganizer getCurrentOrganizer() {
        return this.currentOrganizer;
    }

    private String[] getVersions() {
        String[] commits = new String[]{this.configuration.getFixedCommitConfig().getCommitOld().equals("HEAD~1") ? this.configuration.getFixedCommitConfig().getCommit() + "~1" : this.configuration.getFixedCommitConfig().getCommitOld(), this.configuration.getFixedCommitConfig().getCommit()};
        return commits;
    }
}

