/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.serialization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.dagere.peass.measurement.rca.data.BasicNode;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.data.OneVMResult;
import de.dagere.peass.measurement.rca.serialization.MeasuredValues;
import de.dagere.peass.measurement.statistics.data.TestcaseStatistic;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.inference.TestUtils;

public class MeasuredNode
extends BasicNode {
    private TestcaseStatistic statistic;
    private List<MeasuredNode> children = new LinkedList<MeasuredNode>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private MeasuredValues values;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private MeasuredValues valuesPredecessor;

    @JsonCreator
    public MeasuredNode(@JsonProperty(value="call") String call, @JsonProperty(value="kiekerPattern") String kiekerPattern, @JsonProperty(value="otherKiekerPattern") String otherKiekerPattern) {
        super(call, kiekerPattern, otherKiekerPattern);
    }

    @Override
    public String getCall() {
        return this.call;
    }

    public void setCall(String call) {
        this.call = call;
    }

    @Override
    public String getKiekerPattern() {
        return this.kiekerPattern;
    }

    public void setKiekerPattern(String kiekerPattern) {
        this.kiekerPattern = kiekerPattern;
    }

    public TestcaseStatistic getStatistic() {
        return this.statistic;
    }

    public void setStatistic(TestcaseStatistic statistic) {
        this.statistic = statistic;
    }

    @JsonIgnore
    public int getPureVMs() {
        return this.values.getValues().size();
    }

    @JsonIgnore
    public int getVMsOld() {
        return this.valuesPredecessor.getValues().size();
    }

    public List<MeasuredNode> getChilds() {
        return this.children;
    }

    public void setChilds(List<MeasuredNode> children) {
        this.children = children;
    }

    @JsonIgnore
    public List<MeasuredNode> getChildren() {
        return this.children;
    }

    public MeasuredNode getChildByPattern(String name) {
        MeasuredNode result = null;
        for (MeasuredNode node : this.children) {
            if (!node.getKiekerPattern().contentEquals(name)) continue;
            result = node;
        }
        return result;
    }

    public MeasuredValues getValues() {
        return this.values;
    }

    public void setValues(MeasuredValues values) {
        this.values = values;
    }

    public MeasuredValues getValuesPredecessor() {
        return this.valuesPredecessor;
    }

    public void setValuesPredecessor(MeasuredValues valuesPredecessor) {
        this.valuesPredecessor = valuesPredecessor;
    }

    @JsonIgnore
    public boolean isChange(double type2error) {
        boolean value = TestUtils.tTest((StatisticalSummary)this.statistic.getStatisticsCurrent(), (StatisticalSummary)this.statistic.getStatisticsOld(), (double)type2error);
        return value;
    }

    public void setValues(CallTreeNode rawDataNode, String commit, String predecessor) {
        System.out.println("Persisting: " + commit + " " + rawDataNode.getCall());
        this.values = new MeasuredValues();
        this.valuesPredecessor = new MeasuredValues();
        this.persistValues(rawDataNode.getResults(commit), this.values);
        this.persistValues(rawDataNode.getResults(predecessor), this.valuesPredecessor);
    }

    private void persistValues(List<OneVMResult> results, MeasuredValues values) {
        if (results != null) {
            for (int i = 0; i < results.size(); ++i) {
                OneVMResult oneVMResult = results.get(i);
                List<StatisticalSummary> value = oneVMResult.getValues();
                values.getValues().put(i, value);
            }
        }
    }

    public String toString() {
        return "measured: " + this.kiekerPattern;
    }
}

