/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.serialization;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.dagere.peass.measurement.statistics.StatisticUtil;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MeasuredValues {
    private static final Logger LOG = LogManager.getLogger(MeasuredValues.class);
    private Map<Integer, List<StatisticalSummary>> values = new TreeMap<Integer, List<StatisticalSummary>>();

    public Map<Integer, List<StatisticalSummary>> getValues() {
        return this.values;
    }

    public void setValues(Map<Integer, List<StatisticalSummary>> values) {
        this.values = values;
    }

    @JsonIgnore
    public double[] getValuesArray() {
        double[] aggregated = new double[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            double mean;
            aggregated[i] = mean = StatisticUtil.getMean(this.values.get(i));
            LOG.trace("Mean " + i + " " + mean);
        }
        return aggregated;
    }
}

