/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.treeanalysis;

import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.measurement.rca.CauseSearcherConfig;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.treeanalysis.DifferentNodeDeterminer;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public class AllDifferingDeterminer
extends DifferentNodeDeterminer {
    public AllDifferingDeterminer(List<CallTreeNode> needToMeasurePredecessor, CauseSearcherConfig causeSearchConfig, MeasurementConfig measurementConfig) {
        super(causeSearchConfig, measurementConfig);
        this.measurePredecessor = needToMeasurePredecessor;
    }

    @Override
    public void calculateDiffering() {
        super.calculateDiffering();
    }

    public List<CallTreeNode> getIncludableNodes() {
        LinkedList<CallTreeNode> includeable = new LinkedList<CallTreeNode>();
        for (CallTreeNode node : this.measurePredecessor) {
            SummaryStatistics statistics = node.getStatistics(this.measurementConfig.getFixedCommitConfig().getCommit());
            SummaryStatistics statisticsOld = node.getStatistics(this.measurementConfig.getFixedCommitConfig().getCommitOld());
            if (!(statistics.getMean() > this.causeSearchConfig.getMinTime()) || !(statisticsOld.getMean() > this.causeSearchConfig.getMinTime())) continue;
            includeable.add(node);
        }
        return includeable;
    }
}

