/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.treeanalysis;

import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.measurement.rca.CauseSearcherConfig;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.statistics.Relation;
import de.dagere.peass.measurement.statistics.StatisticUtil;
import de.dagere.peass.measurement.statistics.bimodal.CompareData;
import de.dagere.peass.measurement.statistics.bimodal.OutlierRemoverBimodal;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.stat.inference.TestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DifferentNodeDeterminer {
    private static final Logger LOG = LogManager.getLogger(DifferentNodeDeterminer.class);
    protected List<CallTreeNode> measurePredecessor = new LinkedList<CallTreeNode>();
    protected final List<CallTreeNode> levelDifferentPrecessor = new LinkedList<CallTreeNode>();
    protected final CauseSearcherConfig causeSearchConfig;
    protected final MeasurementConfig measurementConfig;

    public DifferentNodeDeterminer(CauseSearcherConfig causeSearchConfig, MeasurementConfig measurementConfig) {
        this.causeSearchConfig = causeSearchConfig;
        this.measurementConfig = measurementConfig;
    }

    public void calculateDiffering() {
        for (CallTreeNode currentPredecessorNode : this.measurePredecessor) {
            CompareData cd = currentPredecessorNode.getComparableStatistics(this.measurementConfig.getFixedCommitConfig().getCommitOld(), this.measurementConfig.getFixedCommitConfig().getCommit());
            this.calculateNodeDifference(currentPredecessorNode, cd);
        }
    }

    private void calculateNodeDifference(CallTreeNode currentPredecessorNode, CompareData cd) {
        if (cd.getPredecessorStat() == null || cd.getCurrentStat() == null) {
            LOG.debug("Statistics is null, is different: {} vs {}", (Object)cd.getPredecessorStat(), (Object)cd.getCurrentStat());
            this.levelDifferentPrecessor.add(currentPredecessorNode);
        } else {
            CompareData cleaned = this.removeOutliers(cd);
            this.printComparisonInfos(currentPredecessorNode, cleaned.getPredecessorStat(), cleaned.getCurrentStat());
            this.checkNodeDiffering(currentPredecessorNode, cleaned);
        }
    }

    private CompareData removeOutliers(CompareData cd) {
        CompareData cleaned = this.measurementConfig.getStatisticsConfig().getOutlierFactor() != 0.0 && cd.getCurrent().length > 1 && cd.getPredecessor().length > 1 ? OutlierRemoverBimodal.removeOutliers(cd, this.measurementConfig.getStatisticsConfig().getOutlierFactor()) : cd;
        return cleaned;
    }

    private void checkNodeDiffering(CallTreeNode currentPredecessorNode, CompareData cleaned) {
        if (cleaned.getPredecessorStat().getN() > 0L && cleaned.getCurrentStat().getN() > 0L) {
            Relation relation = StatisticUtil.isDifferent(cleaned, this.measurementConfig.getStatisticsConfig());
            boolean needsEnoughTime = this.needsEnoughTime(cleaned.getPredecessorStat(), cleaned.getCurrentStat());
            LOG.debug("Relation: {} Needs enough time: {}", (Object)relation, (Object)needsEnoughTime);
            if (Relation.isUnequal(relation)) {
                this.addChildsToMeasurement(currentPredecessorNode, cleaned.getPredecessorStat(), cleaned.getCurrentStat());
            } else {
                LOG.info("No remeasurement");
            }
        }
    }

    private void printComparisonInfos(CallTreeNode currentPredecessorNode, SummaryStatistics statisticsPredecessor, SummaryStatistics statisticsVersion) {
        LOG.debug("Comparison {} - {}", (Object)currentPredecessorNode.getKiekerPattern(), currentPredecessorNode.getOtherCommitNode() != null ? currentPredecessorNode.getOtherCommitNode().getKiekerPattern() : null);
        LOG.debug("Predecessor: {} {} Current: {} {} ", (Object)statisticsPredecessor.getMean(), (Object)statisticsPredecessor.getStandardDeviation(), (Object)statisticsVersion.getMean(), (Object)statisticsVersion.getStandardDeviation());
    }

    private void addChildsToMeasurement(CallTreeNode currentPredecessorNode, SummaryStatistics statisticsPredecessor, SummaryStatistics statisticsVersion) {
        LOG.debug("Adding {} - T={}", (Object)currentPredecessorNode, (Object)TestUtils.homoscedasticT((StatisticalSummary)statisticsPredecessor, (StatisticalSummary)statisticsVersion));
        this.levelDifferentPrecessor.add(currentPredecessorNode);
    }

    private boolean needsEnoughTime(SummaryStatistics statisticsPredecessor, SummaryStatistics statisticsVersion) {
        double relativeDifference = Math.abs(statisticsPredecessor.getMean() - statisticsVersion.getMean()) / statisticsVersion.getMean();
        double relativeDeviationPredecessor = statisticsPredecessor.getStandardDeviation() / statisticsPredecessor.getMean();
        double relativeDeviationVersion = statisticsVersion.getStandardDeviation() / statisticsVersion.getMean();
        double relativeStandardDeviation = Math.sqrt((Math.pow(relativeDeviationPredecessor, 2.0) + Math.pow(relativeDeviationVersion, 2.0)) / 2.0);
        return relativeDifference > this.causeSearchConfig.getMinTime() * relativeStandardDeviation;
    }

    public List<CallTreeNode> getLevelDifferentPredecessor() {
        return this.levelDifferentPrecessor;
    }

    public List<CallTreeNode> getLevelDifferentCurrent() {
        LinkedList<CallTreeNode> differentPredecessor = new LinkedList<CallTreeNode>();
        this.levelDifferentPrecessor.forEach(node -> differentPredecessor.add(node.getOtherCommitNode()));
        return differentPredecessor;
    }
}

