/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.treeanalysis;

import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.measurement.rca.CauseSearcherConfig;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.treeanalysis.DifferentNodeDeterminer;
import de.dagere.peass.measurement.rca.treeanalysis.TreeUtil;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LevelDifferentNodeDeterminer
extends DifferentNodeDeterminer {
    private static final Logger LOG = LogManager.getLogger(LevelDifferentNodeDeterminer.class);
    protected final List<CallTreeNode> treeStructureDifferentNodes = new LinkedList<CallTreeNode>();

    public LevelDifferentNodeDeterminer(List<CallTreeNode> currentPredecessorNodeList, List<CallTreeNode> currentVersionNodeList, CauseSearcherConfig causeSearchConfig, MeasurementConfig measurementConfig) {
        super(causeSearchConfig, measurementConfig);
        LinkedList<CallTreeNode> currentNodes = new LinkedList<CallTreeNode>(currentVersionNodeList);
        for (CallTreeNode predecessorNode : currentPredecessorNodeList) {
            CallTreeNode currentVersionNode = predecessorNode.getOtherCommitNode();
            if (currentVersionNode == null) {
                throw new RuntimeException("Node " + String.valueOf(predecessorNode) + " was not mapped");
            }
            currentNodes.remove(currentVersionNode);
            this.findMeasurable(predecessorNode, currentVersionNode);
        }
        if (!currentNodes.isEmpty()) {
            LOG.error("Could not map node lists");
            LOG.error("Predecessor: {}", currentPredecessorNodeList);
            LOG.error("Current: {}", currentVersionNodeList);
            throw new RuntimeException("Mapping error");
        }
    }

    private void findMeasurable(CallTreeNode currentPredecessorNode, CallTreeNode currentCommitNode) {
        if (currentPredecessorNode != null && currentCommitNode != null) {
            if (!TreeUtil.childrenEqual(currentPredecessorNode, currentCommitNode)) {
                int matched = TreeUtil.findChildMapping(currentPredecessorNode, currentCommitNode);
                if (matched > 0) {
                    this.measurePredecessor.add(currentPredecessorNode);
                } else {
                    this.treeStructureDifferentNodes.add(currentPredecessorNode);
                    this.treeStructureDifferentNodes.add(currentCommitNode);
                }
            } else {
                this.measurePredecessor.add(currentPredecessorNode);
            }
        } else {
            LOG.info("No child node left: {} {}", (Object)currentPredecessorNode, (Object)currentCommitNode);
        }
    }

    public List<CallTreeNode> getTreeStructureDifferingNodes() {
        return this.treeStructureDifferentNodes;
    }

    public List<CallTreeNode> getMeasurePredecessor() {
        return this.measurePredecessor;
    }
}

