/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.treeanalysis;

import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.treeanalysis.TreeUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;

public class MatchingTreeBuilder {
    private static final Logger LOG = LogManager.getLogger(MatchingTreeBuilder.class);
    final CallTreeNode firstNode;
    final CallTreeNode secondNode;
    final Set<TreeUtil.CallTreeNodeVertex> partition1 = new HashSet<TreeUtil.CallTreeNodeVertex>();
    final Set<TreeUtil.CallTreeNodeVertex> partition2 = new HashSet<TreeUtil.CallTreeNodeVertex>();
    final Graph<TreeUtil.CallTreeNodeVertex, DefaultWeightedEdge> graph = new SimpleWeightedGraph(DefaultWeightedEdge.class);
    final Map<Integer, TreeUtil.CallTreeNodeVertex> vertices1 = new HashMap<Integer, TreeUtil.CallTreeNodeVertex>();
    final Map<Integer, TreeUtil.CallTreeNodeVertex> vertices2 = new HashMap<Integer, TreeUtil.CallTreeNodeVertex>();

    public MatchingTreeBuilder(CallTreeNode firstNode, CallTreeNode secondNode) {
        this.firstNode = firstNode;
        this.secondNode = secondNode;
        this.buildVertices(firstNode, this.partition1, this.vertices1);
        this.buildVertices(secondNode, this.partition2, this.vertices2);
    }

    private void buildVertices(CallTreeNode firstNode, Set<TreeUtil.CallTreeNodeVertex> partition, Map<Integer, TreeUtil.CallTreeNodeVertex> vertices) {
        for (int firstChildIndex = 0; firstChildIndex < firstNode.getChildren().size(); ++firstChildIndex) {
            CallTreeNode child = firstNode.getChildren().get(firstChildIndex);
            TreeUtil.CallTreeNodeVertex vertex = new TreeUtil.CallTreeNodeVertex(child);
            vertices.put(firstChildIndex, vertex);
            partition.add(vertex);
            this.graph.addVertex((Object)vertex);
        }
    }

    public Set<TreeUtil.CallTreeNodeVertex> getPartition1() {
        return this.partition1;
    }

    public Set<TreeUtil.CallTreeNodeVertex> getPartition2() {
        return this.partition2;
    }

    public Graph<TreeUtil.CallTreeNodeVertex, DefaultWeightedEdge> getGraph() {
        return this.graph;
    }

    public void buildEdges(CallTreeNode firstNode, CallTreeNode secondNode, Graph<TreeUtil.CallTreeNodeVertex, DefaultWeightedEdge> graph) {
        for (int firstChildIndex = 0; firstChildIndex < firstNode.getChildren().size(); ++firstChildIndex) {
            for (int secondChildIndex = 0; secondChildIndex < secondNode.getChildren().size(); ++secondChildIndex) {
                CallTreeNode firstChild = firstNode.getChildren().get(firstChildIndex);
                CallTreeNode secondChild = secondNode.getChildren().get(secondChildIndex);
                DefaultWeightedEdge edge = (DefaultWeightedEdge)graph.addEdge((Object)this.vertices1.get(firstChildIndex), (Object)this.vertices2.get(secondChildIndex));
                double weight = this.getWeight(firstChild, secondChild);
                LOG.trace("Edge: " + String.valueOf(firstChild) + " " + String.valueOf(secondChild) + " - " + weight);
                LOG.trace((Object)edge);
                graph.setEdgeWeight((Object)edge, weight);
            }
        }
    }

    private double getWeight(CallTreeNode firstChild, CallTreeNode secondChild) {
        int commonPrefixShare;
        double weight;
        if (firstChild.getKiekerPattern().equals(secondChild.getKiekerPattern())) {
            weight = 1000.0;
        } else if (firstChild.getCall().equals(secondChild.getCall())) {
            commonPrefixShare = MatchingTreeBuilder.getPrefixShare(firstChild, secondChild);
            weight = 300 + commonPrefixShare;
        } else if (firstChild.getCall().equals("ADDED") || secondChild.getCall().equals("ADDED")) {
            weight = 1.0;
        } else if (firstChild.getMethod().equals(secondChild.getMethod())) {
            if (firstChild.getParameters().equals(secondChild.getParameters())) {
                weight = 50.0;
            } else {
                commonPrefixShare = MatchingTreeBuilder.getPrefixShare(firstChild, secondChild);
                weight = 3 + commonPrefixShare;
            }
        } else {
            weight = 1.0;
        }
        int index1 = firstChild.getPosition();
        int index2 = secondChild.getPosition();
        if (index1 == index2) {
            weight += 0.5;
        }
        if (firstChild.getChildren().size() == secondChild.getChildren().size()) {
            weight += 0.5;
        }
        return weight;
    }

    private static int getPrefixShare(CallTreeNode firstChild, CallTreeNode secondChild) {
        String commonPrefix = StringUtils.getCommonPrefix((String[])new String[]{firstChild.getParameters(), secondChild.getParameters()});
        int averageLength = (firstChild.getParameters().length() + secondChild.getParameters().length()) / 2;
        int commonPrefixShare = (int)(10.0 * (double)commonPrefix.length() / (double)averageLength);
        return commonPrefixShare;
    }
}

