/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.rca.treeanalysis;

import de.dagere.peass.measurement.rca.data.BasicNode;
import de.dagere.peass.measurement.rca.data.CallTreeNode;
import de.dagere.peass.measurement.rca.serialization.MeasuredNode;
import de.dagere.peass.measurement.rca.treeanalysis.MatchingTreeBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jgrapht.Graph;
import org.jgrapht.alg.interfaces.MatchingAlgorithm;
import org.jgrapht.alg.matching.MaximumWeightBipartiteMatching;
import org.jgrapht.graph.DefaultWeightedEdge;

public class TreeUtil {
    private static final Logger LOG = LogManager.getLogger(TreeUtil.class);

    public static boolean areTracesEqual(BasicNode firstNode, BasicNode secondNode) {
        if (!firstNode.getKiekerPattern().equals(secondNode.getKiekerPattern())) {
            return false;
        }
        if (firstNode.getChildren().size() != secondNode.getChildren().size()) {
            return false;
        }
        Iterator<? extends BasicNode> firstIt = firstNode.getChildren().iterator();
        Iterator<? extends BasicNode> secondIt = secondNode.getChildren().iterator();
        while (firstIt.hasNext() && secondIt.hasNext()) {
            BasicNode secondChild;
            BasicNode firstChild = firstIt.next();
            if (TreeUtil.areTracesEqual(firstChild, secondChild = secondIt.next())) continue;
            return false;
        }
        return true;
    }

    public static int findChildMapping(CallTreeNode firstNode, CallTreeNode secondNode) {
        MatchingTreeBuilder builder = new MatchingTreeBuilder(firstNode, secondNode);
        Graph<CallTreeNodeVertex, DefaultWeightedEdge> graph = builder.getGraph();
        builder.buildEdges(firstNode, secondNode, graph);
        Set<CallTreeNodeVertex> partition1 = builder.getPartition1();
        Set<CallTreeNodeVertex> partition2 = builder.getPartition2();
        MatchingAlgorithm.Matching<CallTreeNodeVertex, DefaultWeightedEdge> resultMatching = TreeUtil.setOtherVersionNodes(graph, partition1, partition2);
        if (partition1.size() > partition2.size()) {
            TreeUtil.addSurplus(secondNode, firstNode.getChildren());
        }
        if (partition2.size() > partition1.size()) {
            TreeUtil.addSurplus(firstNode, secondNode.getChildren());
        }
        return resultMatching.getEdges().size();
    }

    private static MatchingAlgorithm.Matching<CallTreeNodeVertex, DefaultWeightedEdge> setOtherVersionNodes(Graph<CallTreeNodeVertex, DefaultWeightedEdge> graph, Set<CallTreeNodeVertex> partition1, Set<CallTreeNodeVertex> partition2) {
        MaximumWeightBipartiteMatching matching = new MaximumWeightBipartiteMatching(graph, partition1, partition2);
        MatchingAlgorithm.Matching resultMatching = matching.getMatching();
        for (DefaultWeightedEdge edge : resultMatching) {
            CallTreeNode source = ((CallTreeNodeVertex)graph.getEdgeSource((Object)edge)).getNode();
            CallTreeNode target = ((CallTreeNodeVertex)graph.getEdgeTarget((Object)edge)).getNode();
            source.setOtherCommitNode(target);
            target.setOtherCommitNode(source);
            source.setOtherKiekerPattern(target.getKiekerPattern());
            target.setOtherKiekerPattern(source.getKiekerPattern());
        }
        return resultMatching;
    }

    private static void addSurplus(CallTreeNode otherParent, List<CallTreeNode> partition) {
        for (CallTreeNode unmatched : partition) {
            if (unmatched.getOtherCommitNode() != null) continue;
            CallTreeNode virtual_node = otherParent.appendChild("ADDED", "ADDED", unmatched.getKiekerPattern());
            unmatched.setOtherCommitNode(virtual_node);
            virtual_node.setOtherCommitNode(unmatched);
            unmatched.setOtherKiekerPattern("ADDED");
        }
    }

    public static boolean childrenEqual(CallTreeNode firstNode, CallTreeNode secondNode) {
        Iterator<CallTreeNode> firstIt = firstNode.getChildren().iterator();
        Iterator<CallTreeNode> secondIt = secondNode.getChildren().iterator();
        while (firstIt.hasNext() && secondIt.hasNext()) {
            CallTreeNode firstChild = firstIt.next();
            CallTreeNode secondChild = secondIt.next();
            if (!firstChild.getKiekerPattern().equals(secondChild.getKiekerPattern())) {
                return false;
            }
            firstChild.setOtherKiekerPattern(secondChild.getKiekerPattern());
            secondChild.setOtherKiekerPattern(firstChild.getOtherKiekerPattern());
            firstChild.setOtherCommitNode(secondChild);
            secondChild.setOtherCommitNode(firstChild);
        }
        return true;
    }

    public static boolean childrenEqual(MeasuredNode firstNode, MeasuredNode secondNode) {
        Iterator<MeasuredNode> firstIt = firstNode.getChilds().iterator();
        Iterator<MeasuredNode> secondIt = secondNode.getChilds().iterator();
        while (firstIt.hasNext() && secondIt.hasNext()) {
            MeasuredNode firstChild = firstIt.next();
            MeasuredNode secondChild = secondIt.next();
            if (firstChild.getKiekerPattern().equals(secondChild.getKiekerPattern())) continue;
            return false;
        }
        return true;
    }

    public static class CallTreeNodeVertex {
        final CallTreeNode node;

        public CallTreeNodeVertex(CallTreeNode node) {
            this.node = node;
        }

        public CallTreeNode getNode() {
            return this.node;
        }
    }
}

