/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.statistics;

import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.peass.measurement.statistics.ConfidenceInterval;
import de.dagere.peass.measurement.statistics.MeasurementAnalysationUtil;
import de.dagere.peass.measurement.statistics.PerformanceChange;
import de.dagere.peass.measurement.statistics.Relation;
import de.dagere.peass.measurement.statistics.bimodal.CompareData;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfidenceIntervalInterpretion {
    private static final Logger LOG = LogManager.getLogger(ConfidenceIntervalInterpretion.class);
    private static final int BOOTSTRAP_SIZE = 100;
    private static ThreadLocal<double[]> threadLocalValues = new ThreadLocal();

    public static DescriptiveStatistics getStatistics(List<VMResult> results) {
        DescriptiveStatistics ds = new DescriptiveStatistics();
        results.forEach(result -> ds.addValue(result.getValue()));
        return ds;
    }

    public static Relation compare(CompareData data) {
        return ConfidenceIntervalInterpretion.compare(data, 96);
    }

    public static Relation compare(CompareData data, double type1error) {
        int confidenceIntervalPercentage = (int)(100.0 - type1error * 100.0);
        return ConfidenceIntervalInterpretion.compare(data, confidenceIntervalPercentage);
    }

    public static Relation compare(CompareData data, int percentage) {
        if (percentage < 1 || percentage > 99) {
            throw new RuntimeException("Percentage between 1 and 99 expected");
        }
        ConfidenceInterval intervalPredecessor = ConfidenceIntervalInterpretion.getConfidenceInterval(data.getPredecessor(), percentage);
        ConfidenceInterval intervalCurrent = ConfidenceIntervalInterpretion.getConfidenceInterval(data.getCurrent(), percentage);
        double avgPredecessor = data.getAvgPredecessor();
        double avgCurrent = data.getAvgCurrent();
        LOG.trace("Intervalle: {} ({}) vs. vorher {} ({})", (Object)intervalCurrent, (Object)avgCurrent, (Object)intervalPredecessor, (Object)avgPredecessor);
        PerformanceChange change = new PerformanceChange(intervalPredecessor, intervalCurrent, "", "", "0", "1");
        double diff = change.getDifference();
        if (intervalPredecessor.getMax() < intervalCurrent.getMin()) {
            LOG.trace("\u00c4nderung: {} {} Diff: {}", (Object)change.getRevisionOld(), (Object)change.getTestMethod(), (Object)diff);
            LOG.trace("Ist kleiner geworden: {} vs. vorher {}", (Object)intervalCurrent, (Object)intervalPredecessor);
            LOG.trace("Abstand: {} Versionen: {}:{}", (Object)diff);
            return Relation.LESS_THAN;
        }
        if (intervalPredecessor.getMin() > intervalCurrent.getMax()) {
            LOG.trace("\u00c4nderung: {} {} Diff: {}", (Object)change.getRevisionOld(), (Object)change.getTestMethod(), (Object)diff);
            LOG.trace("Ist gr\u00f6\u00dfer geworden: {} vs. vorher {}", (Object)intervalCurrent, (Object)intervalPredecessor);
            LOG.trace("Abstand: {}", (Object)diff);
            return Relation.GREATER_THAN;
        }
        return Relation.EQUAL;
    }

    public static ConfidenceInterval getConfidenceInterval(double[] rawValues, int percentage) {
        double[] values = threadLocalValues.get();
        if (values == null) {
            values = new double[100];
            threadLocalValues.set(values);
        }
        ConfidenceInterval interval = MeasurementAnalysationUtil.getBootstrapConfidenceInterval(rawValues, rawValues.length, values, percentage);
        return interval;
    }
}

