/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.statistics;

import de.dagere.kopeme.datastorage.JSONDataLoader;
import de.dagere.kopeme.kopemedata.DatacollectorResult;
import de.dagere.kopeme.kopemedata.Kopemedata;
import de.dagere.kopeme.kopemedata.TestMethod;
import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.peass.measurement.statistics.ConfidenceInterval;
import de.dagere.peass.measurement.statistics.PerformanceChange;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MeasurementAnalysationUtil {
    private static final Logger LOG = LogManager.getLogger(MeasurementAnalysationUtil.class);
    static long earliestVersion = Long.MAX_VALUE;
    static long lastVersion = Long.MIN_VALUE;
    public static final double MIN_NORMED_DISTANCE = 0.5;
    public static final double MIN_ABSOLUTE_PERCENTAGE_DISTANCE = 0.2;
    private static final ThreadLocalRandom RANDOM = ThreadLocalRandom.current();

    private MeasurementAnalysationUtil() {
    }

    public static Map<File, Kopemedata> getData(File file) {
        HashMap<File, Kopemedata> data = new HashMap<File, Kopemedata>();
        LOG.debug("Analysiere: {}", (Object)file);
        if (file.isDirectory()) {
            Collection fileList = FileUtils.listFiles((File)file, (IOFileFilter)new WildcardFileFilter("*.json"), (IOFileFilter)FalseFileFilter.INSTANCE);
            for (File jsonFile : fileList) {
                LOG.trace("Datei: {}", (Object)jsonFile);
                Kopemedata currentData = JSONDataLoader.loadData((File)jsonFile);
                data.put(jsonFile, currentData);
            }
        }
        return data;
    }

    public static List<PerformanceChange> analyzeKopemeData(Kopemedata data) {
        LinkedHashMap results = new LinkedHashMap();
        int maxResultSize = 0;
        TestMethod currentTestcase = data.getFirstMethodResult();
        final String clazz = data.getClazz();
        final String method = currentTestcase.getMethod();
        List datacollectors = currentTestcase.getDatacollectorResults();
        if (datacollectors.size() != 1) {
            LOG.warn("Mehr als ein DataCollector bei: {}", (Object)method);
        }
        for (VMResult result : ((DatacollectorResult)datacollectors.get(0)).getResults()) {
            String gitCommit = result.getCommit();
            if (!results.containsKey(gitCommit)) {
                results.put(gitCommit, new LinkedList());
            }
            ((List)results.get(gitCommit)).add(result);
            if (((List)results.get(gitCommit)).size() <= maxResultSize) continue;
            maxResultSize = ((List)results.get(gitCommit)).size();
        }
        ConfidenceInterval previous = null;
        String previousVersion = null;
        final LinkedList<PerformanceChange> changes = new LinkedList<PerformanceChange>();
        ExecutorService service = Executors.newFixedThreadPool(4);
        for (final Map.Entry entry : results.entrySet()) {
            double[] values = MeasurementAnalysationUtil.getAveragesArrayFromResults((List)entry.getValue());
            final ConfidenceInterval interval = MeasurementAnalysationUtil.getBootstrapConfidenceInterval(values, 20, 1000, 96);
            LOG.trace("{}-Konfidenzintervall: {} - {}", (Object)interval.getPercentage(), (Object)interval.getMin(), (Object)interval.getMax());
            if (previous != null) {
                final ConfidenceInterval previousConfidenceInterval = previous;
                final String previousVersion2 = previousVersion;
                LOG.trace("Start " + previousVersion2);
                service.execute(new Runnable(){

                    @Override
                    public void run() {
                        String currentVersion = ((VMResult)((List)entry.getValue()).get(0)).getCommit();
                        PerformanceChange change = new PerformanceChange(previousConfidenceInterval, interval, clazz, method, previousVersion2, currentVersion);
                        boolean isChange = MeasurementAnalysationUtil.analysePotentialChange(change, previousConfidenceInterval, entry, interval);
                        if (isChange) {
                            changes.add(change);
                        }
                    }
                });
            }
            previous = interval;
            previousVersion = (String)entry.getKey();
        }
        try {
            service.shutdown();
            service.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return changes;
    }

    public static double[] getAveragesArrayFromResults(List<VMResult> results) {
        double[] values = new double[results.size()];
        int i = 0;
        for (VMResult result : results) {
            double value = result.getValue();
            values[i++] = value;
        }
        return values;
    }

    private static boolean analysePotentialChange(PerformanceChange change, ConfidenceInterval previous, Map.Entry<String, List<VMResult>> entry, ConfidenceInterval interval) {
        LOG.trace("Vergleiche: {} {} Version: {}", (Object)change.getTestClass(), (Object)change.getTestMethod(), (Object)change.getRevisionOld());
        boolean isChange = false;
        double diff = change.getDifference();
        LOG.debug("Teste: {}:{} - {} vs. vorher {}", (Object)change.getRevision(), (Object)change.getRevisionOld(), (Object)interval, (Object)previous);
        if (interval.getMax() < previous.getMin() && change.getNormedDifference() > 0.5 && diff > 0.2 * previous.getMax()) {
            LOG.debug("\u00c4nderung: {} {} Diff: {}", (Object)change.getRevisionOld(), (Object)change.getTestMethod(), (Object)diff);
            LOG.debug("Ist kleiner geworden: {} vs. vorher {}", (Object)interval, (Object)previous);
            LOG.trace("Abstand: {} Versionen: {}:{}", (Object)diff, (Object)change.getRevisionOld(), (Object)entry.getKey());
            isChange = true;
        }
        if (interval.getMin() > previous.getMax() && change.getNormedDifference() > 0.5 && diff > 0.2 * previous.getMax()) {
            LOG.debug("\u00c4nderung: {} {} Diff: {}", (Object)change.getRevisionOld(), (Object)change.getTestMethod(), (Object)diff);
            LOG.debug("Ist gr\u00f6\u00dfer geworden: {} vs. vorher {}", (Object)interval, (Object)previous);
            LOG.trace("Abstand: {} Versionen: {}:{}", (Object)diff, (Object)change.getRevisionOld(), (Object)entry.getKey());
            isChange = true;
        }
        return isChange;
    }

    public static ConfidenceInterval getBootstrapConfidenceInterval(double[] values, int count, double[] repetitionValues, int intervalPercentage) {
        LOG.trace("Werte: {}", (Object)values);
        double[] means = MeasurementAnalysationUtil.getMeanStatistics(values, count, repetitionValues);
        double upperBound = new Percentile((double)intervalPercentage).evaluate(means);
        double lowerBound = new Percentile((double)(100 - intervalPercentage)).evaluate(means);
        return new ConfidenceInterval(lowerBound, upperBound, intervalPercentage);
    }

    public static ConfidenceInterval getBootstrapConfidenceInterval(double[] values, int count, int repetitions, int intervalPercentage) {
        LOG.trace("Werte: {}", (Object)values);
        double[] means = MeasurementAnalysationUtil.getMeanStatistics(values, count, new double[repetitions]);
        double upperBound = new Percentile((double)intervalPercentage).evaluate(means);
        double lowerBound = new Percentile((double)(100 - intervalPercentage)).evaluate(means);
        return new ConfidenceInterval(lowerBound, upperBound, intervalPercentage);
    }

    private static double[] getMeanStatistics(double[] values, int count, double[] meanValues) {
        for (int i = 0; i < meanValues.length; ++i) {
            double bootstrapMean;
            meanValues[i] = bootstrapMean = MeasurementAnalysationUtil.getBootstrappedStatistics(values, count);
        }
        return meanValues;
    }

    private static double getBootstrappedStatistics(double[] values, int count) {
        SummaryStatistics st = new SummaryStatistics();
        st.setSumLogImpl((StorelessUnivariateStatistic)new DummyStatistic());
        for (int i = 0; i < count; ++i) {
            int nextInt = RANDOM.nextInt(values.length);
            st.addValue(values[nextInt]);
        }
        return st.getMean();
    }

    private static final class DummyStatistic
    implements StorelessUnivariateStatistic {
        private DummyStatistic() {
        }

        public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
            return 0.0;
        }

        public double evaluate(double[] values) throws MathIllegalArgumentException {
            return 0.0;
        }

        public void incrementAll(double[] values, int start, int length) throws MathIllegalArgumentException {
        }

        public void incrementAll(double[] values) throws MathIllegalArgumentException {
        }

        public void increment(double d) {
        }

        public double getResult() {
            return 0.0;
        }

        public long getN() {
            return 0L;
        }

        public StorelessUnivariateStatistic copy() {
            return null;
        }

        public void clear() {
        }
    }
}

