/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.statistics;

import de.dagere.peass.measurement.statistics.ConfidenceInterval;

public class PerformanceChange {
    private final ConfidenceInterval intervalOld;
    private final ConfidenceInterval intervalNew;
    private final String testClass;
    private final String testMethod;
    private final String revision;
    private final String revisionOld;

    public PerformanceChange(ConfidenceInterval intervalOld, ConfidenceInterval intervalNew, String testClass, String testMethod, String revisionOld, String revision) {
        this.intervalOld = intervalOld;
        this.intervalNew = intervalNew;
        this.testClass = testClass;
        this.testMethod = testMethod;
        this.revision = revision;
        this.revisionOld = revisionOld;
    }

    public ConfidenceInterval getIntervalOld() {
        return this.intervalOld;
    }

    public ConfidenceInterval getIntervalNew() {
        return this.intervalNew;
    }

    public String getTestClass() {
        return this.testClass;
    }

    public String getTestMethod() {
        return this.testMethod;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getRevisionOld() {
        return this.revisionOld;
    }

    public double getNormedDifference() {
        double intervalLength = (this.intervalNew.getLength() + this.intervalOld.getLength()) / 2.0;
        return this.getDifference() / intervalLength;
    }

    public double getDifference() {
        if (this.intervalNew.getMax() < this.intervalOld.getMin()) {
            return this.intervalOld.getMin() - this.intervalNew.getMax();
        }
        if (this.intervalNew.getMin() > this.intervalOld.getMax()) {
            return this.intervalNew.getMin() - this.intervalOld.getMax();
        }
        return 0.0;
    }

    public String toString() {
        return this.testClass + "." + this.testMethod + " (" + this.revision + ":" + this.revisionOld + ")" + String.valueOf(this.intervalNew) + " Vorher: " + String.valueOf(this.intervalOld);
    }
}

