/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.statistics;

import de.dagere.kopeme.kopemedata.Fulldata;
import de.dagere.kopeme.kopemedata.MeasuredValue;
import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.peass.config.StatisticsConfig;
import de.dagere.peass.measurement.statistics.ConfidenceIntervalInterpretion;
import de.dagere.peass.measurement.statistics.Relation;
import de.dagere.peass.measurement.statistics.bimodal.BimodalityTester;
import de.dagere.peass.measurement.statistics.bimodal.CompareData;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.stat.descriptive.AggregateSummaryStatistics;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.StatisticalSummaryValues;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.commons.math3.stat.inference.MannWhitneyUTest;
import org.apache.commons.math3.stat.inference.TTest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatisticUtil {
    private static final Logger LOG = LogManager.getLogger(StatisticUtil.class);

    public static double getMean(List<StatisticalSummary> statistics) {
        StatisticalSummaryValues vals = AggregateSummaryStatistics.aggregate(statistics);
        return vals != null ? vals.getMean() : Double.NaN;
    }

    private static Relation bimodalTTest(CompareData data, double type1error) {
        BimodalityTester tester = new BimodalityTester(data);
        if (tester.isTChange(type1error)) {
            return tester.getRelation();
        }
        return Relation.EQUAL;
    }

    public static boolean isBimodal(List<VMResult> valuesPredecessor, List<VMResult> valuesCurrent) {
        CompareData data = new CompareData(valuesPredecessor, valuesCurrent);
        BimodalityTester tester = new BimodalityTester(data);
        return tester.isBimodal();
    }

    public static Relation agnosticTTest(StatisticalSummary statisticsPredecessor, StatisticalSummary statisticsCurrent, double type1error, double type2error) {
        double tValue = StatisticUtil.getTValue(statisticsPredecessor, statisticsCurrent, 0.0);
        System.out.println(tValue);
        return StatisticUtil.agnosticTTest(tValue, statisticsPredecessor.getN() + statisticsCurrent.getN() - 2L, type1error, type2error);
    }

    public static Relation agnosticTTest(double tValue, long degreesOfFreedom, double type1error, double type2error) {
        double criticalValueEqual = StatisticUtil.getCriticalValueEqual(type2error, degreesOfFreedom);
        double criticalValueUnequal = StatisticUtil.getCriticalValueUnequal(type1error, degreesOfFreedom);
        LOG.debug("Allowed errors: {} {}", (Object)type1error, (Object)type2error);
        LOG.debug("Critical values: {} {}", (Object)criticalValueUnequal, (Object)criticalValueEqual);
        LOG.debug("T: {}", (Object)tValue);
        if (Math.abs(tValue) > criticalValueUnequal) {
            return tValue > 0.0 ? Relation.GREATER_THAN : Relation.LESS_THAN;
        }
        if (Math.abs(tValue) < criticalValueEqual) {
            return Relation.EQUAL;
        }
        return Relation.UNKOWN;
    }

    public static double getCriticalValueTTest(double type1error, long degreesOfFreedom) {
        return StatisticUtil.getCriticalValueUnequal(type1error, degreesOfFreedom);
    }

    public static double getCriticalValueUnequal(double type2error, long degreesOfFreedom) {
        TDistribution tDistribution = new TDistribution(null, (double)degreesOfFreedom);
        double criticalValueUnequal = Math.abs(tDistribution.inverseCumulativeProbability(1.0 - 0.5 * type2error));
        return criticalValueUnequal;
    }

    public static double getCriticalValueEqual(double type1error, long degreesOfFreedom) {
        TDistribution tDistribution = new TDistribution(null, (double)degreesOfFreedom);
        double criticalValueEqual = Math.abs(tDistribution.inverseCumulativeProbability(0.5 * (1.0 + type1error)));
        return criticalValueEqual;
    }

    public static double getTValue(StatisticalSummary statisticsCurrent, StatisticalSummary statisticsPredecessor, double omega) {
        double n = statisticsCurrent.getN();
        double m = statisticsPredecessor.getN();
        double sizeFactor = Math.sqrt(m * n / (m + n));
        double upperPart = (m - 1.0) * Math.pow(statisticsPredecessor.getStandardDeviation(), 2.0) + (n - 1.0) * Math.pow(statisticsCurrent.getStandardDeviation(), 2.0);
        double s = Math.sqrt(upperPart / (m + n - 2.0));
        double difference = statisticsCurrent.getMean() - statisticsPredecessor.getMean() - omega;
        double tAlternative = sizeFactor * difference / s;
        return tAlternative;
    }

    public static Relation agnosticTTest(StatisticalSummary statisticsPredecessor, StatisticalSummary statisticsCurrent, StatisticsConfig statisticsConfig) {
        return StatisticUtil.agnosticTTest(statisticsPredecessor, statisticsCurrent, statisticsConfig.getType1error(), statisticsConfig.getType2error());
    }

    public static Relation isChange(StatisticalSummary statisticsPrev, StatisticalSummary statisticsVersion, StatisticsConfig statisticsConfig) {
        double maxVal = Math.max(statisticsPrev.getMean(), statisticsVersion.getMean());
        if (maxVal > 1.0) {
            return StatisticUtil.agnosticTTest(statisticsPrev, statisticsVersion, statisticsConfig);
        }
        Relation r1 = StatisticUtil.agnosticTTest(statisticsPrev, statisticsVersion, statisticsConfig.getType1error() / 20.0, statisticsConfig.getType2error() / 20.0);
        double tValue = StatisticUtil.getTValue(statisticsPrev, statisticsVersion, 0.0);
        if (Math.abs(tValue) < 10.0) {
            r1 = Relation.UNKOWN;
        }
        return r1;
    }

    public static VMResult shortenResult(VMResult result, int start, int end) {
        VMResult resultShort = StatisticUtil.copyResultBasics(result);
        SummaryStatistics statistics = new SummaryStatistics();
        int size = Math.min(end, result.getFulldata().getValues().size());
        if (start > size) {
            throw new RuntimeException("Start (" + start + ") is after end of data (" + size + ").");
        }
        if (end > size) {
            throw new RuntimeException("End (" + end + ") is after end of data (" + size + ").");
        }
        for (int i = start; i < size; ++i) {
            MeasuredValue value = (MeasuredValue)result.getFulldata().getValues().get(i);
            Fulldata fulldata = resultShort.getFulldata();
            fulldata.getValues().add(value);
            statistics.addValue((double)value.getValue());
        }
        resultShort.setValue(statistics.getMean());
        resultShort.setDeviation(statistics.getStandardDeviation());
        resultShort.setIterations((long)(end - start));
        resultShort.setWarmup((long)start);
        resultShort.setRepetitions(result.getRepetitions());
        resultShort.setParameters(result.getParameters());
        return resultShort;
    }

    private static VMResult copyResultBasics(VMResult result) {
        VMResult resultShort = new VMResult();
        resultShort.setCpu(result.getCpu());
        resultShort.setDate(result.getDate());
        resultShort.setMemory(result.getMemory());
        resultShort.setFulldata(new Fulldata());
        return resultShort;
    }

    public static VMResult shortenResult(VMResult result) {
        int start = result.getFulldata().getValues().size() / 2;
        int end = result.getFulldata().getValues().size();
        VMResult resultShort = StatisticUtil.shortenResult(result, start, end);
        return resultShort;
    }

    public static List<VMResult> shortenValues(List<VMResult> values, int start, int end) {
        ArrayList<VMResult> shortenedValues = new ArrayList<VMResult>(values.size());
        int index = 0;
        for (VMResult result : values) {
            ++index;
            try {
                VMResult resultShort = StatisticUtil.shortenResult(result, start, end);
                shortenedValues.add(resultShort);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Error in result " + index, e);
            }
        }
        return shortenedValues;
    }

    public static List<VMResult> shortenValues(List<VMResult> values) {
        ArrayList<VMResult> shortenedValues = new ArrayList<VMResult>(values.size());
        for (VMResult result : values) {
            VMResult resultShort = StatisticUtil.shortenResult(result);
            shortenedValues.add(resultShort);
        }
        return shortenedValues;
    }

    public static Relation getTTestRelation(CompareData cd, double type1error) {
        boolean tchange = new TTest().homoscedasticTTest(cd.getPredecessor(), cd.getCurrent(), type1error);
        if (tchange) {
            return cd.getAvgPredecessor() < cd.getAvgCurrent() ? Relation.LESS_THAN : Relation.GREATER_THAN;
        }
        return Relation.EQUAL;
    }

    public static Relation getMannWhitneyRelation(CompareData cd, double type1error) {
        boolean mannchange;
        double statistic = new MannWhitneyUTest().mannWhitneyUTest(cd.getPredecessor(), cd.getCurrent());
        LOG.trace("Mann-Whitney-Statistic: {}", (Object)statistic);
        boolean bl = mannchange = statistic < type1error;
        if (mannchange) {
            return cd.getAvgPredecessor() < cd.getAvgCurrent() ? Relation.LESS_THAN : Relation.GREATER_THAN;
        }
        return Relation.EQUAL;
    }

    public static Relation isDifferent(List<VMResult> valuesPredecessor, List<VMResult> valuesCommit, StatisticsConfig statisticsConfig) {
        CompareData data = new CompareData(valuesPredecessor, valuesCommit);
        return StatisticUtil.isDifferent(data, statisticsConfig);
    }

    public static Relation isDifferent(CompareData cd, StatisticsConfig statisticsConfig) {
        switch (statisticsConfig.getStatisticTest()) {
            case AGNOSTIC_T_TEST: {
                return StatisticUtil.agnosticTTest((StatisticalSummary)cd.getPredecessorStat(), (StatisticalSummary)cd.getCurrentStat(), statisticsConfig);
            }
            case BIMODAL_T_TEST: {
                return StatisticUtil.bimodalTTest(cd, statisticsConfig.getType1error());
            }
            case T_TEST: {
                return StatisticUtil.getTTestRelation(cd, statisticsConfig.getType1error());
            }
            case MANN_WHITNEY_TEST: {
                return StatisticUtil.getMannWhitneyRelation(cd, statisticsConfig.getType1error());
            }
            case CONFIDENCE_INTERVAL: {
                return ConfidenceIntervalInterpretion.compare(cd, statisticsConfig.getType1error());
            }
            case ANY: {
                boolean isChange = StatisticUtil.agnosticTTest((StatisticalSummary)cd.getPredecessorStat(), (StatisticalSummary)cd.getCurrentStat(), statisticsConfig) != Relation.EQUAL || StatisticUtil.bimodalTTest(cd, statisticsConfig.getType1error()) != Relation.EQUAL || StatisticUtil.getTTestRelation(cd, statisticsConfig.getType1error()) != Relation.EQUAL || StatisticUtil.getMannWhitneyRelation(cd, statisticsConfig.getType1error()) != Relation.EQUAL || ConfidenceIntervalInterpretion.compare(cd) != Relation.EQUAL;
                LOG.info("Test results ");
                LOG.info("Agnostic t: {}", (Object)(StatisticUtil.agnosticTTest((StatisticalSummary)cd.getPredecessorStat(), (StatisticalSummary)cd.getCurrentStat(), statisticsConfig) != Relation.EQUAL ? 1 : 0));
                LOG.info("Bimodal T: {}", (Object)(StatisticUtil.bimodalTTest(cd, statisticsConfig.getType1error()) != Relation.EQUAL ? 1 : 0));
                LOG.info("T Test: {}", (Object)(StatisticUtil.getTTestRelation(cd, statisticsConfig.getType1error()) != Relation.EQUAL ? 1 : 0));
                LOG.info("Mann-Whitney: {}", (Object)(StatisticUtil.getMannWhitneyRelation(cd, statisticsConfig.getType1error()) != Relation.EQUAL ? 1 : 0));
                LOG.info("Confidence interval: {}", (Object)(ConfidenceIntervalInterpretion.compare(cd, statisticsConfig.getType1error()) != Relation.EQUAL ? 1 : 0));
                LOG.info("isChange: {}", (Object)isChange);
                if (isChange) {
                    return cd.getAvgPredecessor() < cd.getAvgCurrent() ? Relation.LESS_THAN : Relation.GREATER_THAN;
                }
                return Relation.EQUAL;
            }
            case ANY_NO_AGNOSTIC: {
                boolean isChangeNoAgnostic = StatisticUtil.bimodalTTest(cd, statisticsConfig.getType1error()) != Relation.EQUAL || StatisticUtil.getTTestRelation(cd, statisticsConfig.getType1error()) != Relation.EQUAL || StatisticUtil.getMannWhitneyRelation(cd, statisticsConfig.getType1error()) != Relation.EQUAL || ConfidenceIntervalInterpretion.compare(cd) != Relation.EQUAL;
                LOG.info("Test results ");
                LOG.info("Bimodal T: {}", (Object)(StatisticUtil.bimodalTTest(cd, statisticsConfig.getType1error()) != Relation.EQUAL ? 1 : 0));
                LOG.info("T Test: {}", (Object)(StatisticUtil.getTTestRelation(cd, statisticsConfig.getType1error()) != Relation.EQUAL ? 1 : 0));
                LOG.info("Mann-Whitney: {}", (Object)(StatisticUtil.getMannWhitneyRelation(cd, statisticsConfig.getType1error()) != Relation.EQUAL ? 1 : 0));
                LOG.info("Confidence interval: {}", (Object)(ConfidenceIntervalInterpretion.compare(cd, statisticsConfig.getType1error()) != Relation.EQUAL ? 1 : 0));
                LOG.info("isChange: {}", (Object)isChangeNoAgnostic);
                if (isChangeNoAgnostic) {
                    return cd.getAvgPredecessor() < cd.getAvgCurrent() ? Relation.LESS_THAN : Relation.GREATER_THAN;
                }
                return Relation.EQUAL;
            }
        }
        throw new RuntimeException("Test " + String.valueOf(statisticsConfig.getStatisticTest()) + " currently not implemented");
    }

    public static void removeWarmup(int remainingWarmup, List<StatisticalSummary> statistic) {
        if (remainingWarmup > 0) {
            ListIterator<StatisticalSummary> it = statistic.listIterator();
            while (it.hasNext()) {
                StatisticalSummary chunk = it.next();
                long countOfExecutions = chunk.getN();
                if ((long)remainingWarmup >= countOfExecutions) {
                    remainingWarmup = (int)((long)remainingWarmup - countOfExecutions);
                    LOG.debug("Reducing warmup by {}, remaining warmup {}", (Object)countOfExecutions, (Object)remainingWarmup);
                    it.remove();
                    continue;
                }
                if (remainingWarmup > 0) {
                    long reducedN = countOfExecutions - (long)remainingWarmup;
                    remainingWarmup = 0;
                    StatisticalSummaryValues replacement = new StatisticalSummaryValues(chunk.getMean(), chunk.getVariance(), reducedN, chunk.getMax(), chunk.getMin(), chunk.getMean() * (double)reducedN);
                    it.set((StatisticalSummary)replacement);
                    continue;
                }
                StatisticalSummaryValues replacement = new StatisticalSummaryValues(chunk.getMean(), chunk.getVariance(), countOfExecutions, chunk.getMax(), chunk.getMin(), chunk.getMean() * (double)countOfExecutions);
                it.set((StatisticalSummary)replacement);
            }
            if (remainingWarmup > 0) {
                LOG.warn("Warning! Reading aggregated data which contain less executions than the warmup " + remainingWarmup);
            }
            for (StatisticalSummary summary : statistic) {
                LOG.trace("After removing: {} {} Sum: {}", (Object)summary.getMean(), (Object)summary.getN(), (Object)summary.getSum());
                if (summary.getN() != 0L) continue;
                throw new RuntimeException("Final statistics with 0 entries do not make sense!");
            }
            LOG.trace("Overall mean: {}", (Object)StatisticUtil.getMean(statistic));
        }
    }

    public static double getMannWhitneyUStatistic(double[] dataOld, double[] dataCurrent) {
        return new MannWhitneyUTest().mannWhitneyUTest(dataOld, dataCurrent);
    }

    public static Double getMannWhitneyUStatistic(DescriptiveStatistics statisticsOld, DescriptiveStatistics statisticsCurrent) {
        return StatisticUtil.getMannWhitneyUStatistic(statisticsOld.getValues(), statisticsCurrent.getValues());
    }
}

