/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.statistics.bimodal;

import de.dagere.peass.measurement.statistics.Relation;
import de.dagere.peass.measurement.statistics.bimodal.CompareData;
import de.dagere.peass.measurement.statistics.bimodal.IsBimodal;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.inference.TTest;

public class BimodalityTester {
    private final CompareData data;
    final IsBimodal dataPredecessor;
    final IsBimodal dataCurrent;
    private final boolean isBimodal;
    private final Relation relation;

    public BimodalityTester(CompareData data) {
        this.data = data;
        this.dataPredecessor = new IsBimodal(data.getPredecessor(), data.getPredecessorStat());
        this.dataCurrent = new IsBimodal(data.getCurrent(), data.getCurrentStat());
        boolean bl = this.isBimodal = this.dataPredecessor.isBimodal() && this.dataCurrent.isBimodal();
        if (this.isBimodal) {
            boolean secondSmaller;
            boolean firstSmaller = this.dataPredecessor.getStat1().getMean() < this.dataCurrent.getStat1().getMean();
            boolean bl2 = secondSmaller = this.dataPredecessor.getStat2().getMean() < this.dataCurrent.getStat2().getMean();
            this.relation = firstSmaller && secondSmaller ? Relation.LESS_THAN : (!firstSmaller && !secondSmaller ? Relation.GREATER_THAN : Relation.EQUAL);
        } else {
            this.relation = data.getAvgPredecessor() < data.getAvgCurrent() ? Relation.LESS_THAN : Relation.GREATER_THAN;
        }
    }

    public IsBimodal getDataPredecessor() {
        return this.dataPredecessor;
    }

    public IsBimodal getDataAfter() {
        return this.dataCurrent;
    }

    public boolean isTChange(double significance) {
        if (this.isBimodal) {
            boolean firstChanged = new TTest().homoscedasticTTest((StatisticalSummary)this.dataPredecessor.getStat1(), (StatisticalSummary)this.dataCurrent.getStat1()) < significance;
            boolean secondChanged = new TTest().homoscedasticTTest((StatisticalSummary)this.dataPredecessor.getStat2(), (StatisticalSummary)this.dataCurrent.getStat2()) < significance;
            boolean firstSmaller = this.dataPredecessor.getStat1().getMean() < this.dataCurrent.getStat1().getMean();
            boolean secondSmaller = this.dataPredecessor.getStat2().getMean() < this.dataCurrent.getStat2().getMean();
            boolean sameDirection = firstSmaller == secondSmaller;
            boolean isChange = firstChanged && secondChanged && sameDirection;
            return isChange;
        }
        return new TTest().homoscedasticTTest(this.data.getPredecessor(), this.data.getCurrent(), significance);
    }

    public Relation getRelation() {
        return this.relation;
    }

    public boolean isBimodal() {
        return this.isBimodal;
    }
}

