/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.statistics.bimodal;

import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.peass.measurement.rca.data.OneVMResult;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public final class CompareData {
    private final double[] predecessor;
    private final double[] current;
    private final SummaryStatistics predecessorStat;
    private final SummaryStatistics currentStat;

    public CompareData(double[] predecessor, double[] current) {
        this.predecessor = predecessor;
        this.current = current;
        if (predecessor != null) {
            this.predecessorStat = new SummaryStatistics();
            for (double predecessorVal : predecessor) {
                this.predecessorStat.addValue(predecessorVal);
            }
        } else {
            this.predecessorStat = null;
        }
        if (current != null) {
            this.currentStat = new SummaryStatistics();
            for (double currentVal : current) {
                this.currentStat.addValue(currentVal);
            }
        } else {
            this.currentStat = null;
        }
    }

    public CompareData(List<VMResult> predecessorShortened, List<VMResult> currentShortened) {
        this.predecessorStat = new SummaryStatistics();
        this.predecessor = new double[predecessorShortened.size()];
        int index = 0;
        for (VMResult result : predecessorShortened) {
            this.predecessor[index] = result.getValue();
            this.getPredecessorStat().addValue(this.predecessor[index]);
            ++index;
        }
        this.currentStat = new SummaryStatistics();
        this.current = new double[currentShortened.size()];
        index = 0;
        for (VMResult result : currentShortened) {
            this.current[index] = result.getValue();
            this.getCurrentStat().addValue(this.current[index]);
            ++index;
        }
    }

    public static CompareData createCompareDataFromOneVMResults(List<OneVMResult> predecessorVals, List<OneVMResult> currentVals) {
        double[] predecessor = CompareData.getDoubleArray(predecessorVals);
        double[] current = CompareData.getDoubleArray(currentVals);
        return new CompareData(predecessor, current);
    }

    private static double[] getDoubleArray(List<OneVMResult> sourceVals) {
        double[] valueArray;
        if (sourceVals != null) {
            valueArray = new double[sourceVals.size()];
            int index = 0;
            for (OneVMResult result : sourceVals) {
                valueArray[index] = result.getAverage();
                ++index;
            }
        } else {
            valueArray = null;
        }
        return valueArray;
    }

    public double getAvgCurrent() {
        return this.getCurrentStat().getMean();
    }

    public double getAvgPredecessor() {
        return this.getPredecessorStat().getMean();
    }

    public double[] getPredecessor() {
        return this.predecessor;
    }

    public double[] getCurrent() {
        return this.current;
    }

    public SummaryStatistics getPredecessorStat() {
        return this.predecessorStat;
    }

    public SummaryStatistics getCurrentStat() {
        return this.currentStat;
    }
}

