/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.statistics.bimodal;

import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class Division {
    private static final Logger LOG = LogManager.getLogger(Division.class);
    final SummaryStatistics statisticCandidate1 = new SummaryStatistics();
    final SummaryStatistics statisticCandidate2 = new SummaryStatistics();
    final int divisionIndex;
    double divisionMeanvalue;

    public Division(double[] values, int divisionIndex) {
        this.divisionMeanvalue = values[divisionIndex];
        this.divisionIndex = divisionIndex;
        for (double value : values) {
            if (value < this.divisionMeanvalue) {
                this.statisticCandidate1.addValue(value);
                continue;
            }
            this.statisticCandidate2.addValue(value);
        }
    }

    public double getSummaryVariance() {
        return this.statisticCandidate1.getVariance() + this.statisticCandidate2.getVariance();
    }

    static Division getOptimalDivision(double[] values, Division lastDivision, int prevIndex) {
        int lastMiddleIndex = lastDivision.divisionIndex;
        int checkedDelta = Math.abs(prevIndex - lastMiddleIndex) / 2;
        if (checkedDelta == 0) {
            LOG.trace("Finally: " + lastDivision.divisionIndex + " " + lastDivision.divisionMeanvalue);
            return lastDivision;
        }
        Division leftPartDivision = new Division(values, lastMiddleIndex - checkedDelta);
        Division rightPartDivision = new Division(values, lastMiddleIndex + checkedDelta);
        Division result = null;
        LOG.trace("Checking left: {} {} Index: {}", (Object)leftPartDivision.getSummaryVariance(), (Object)lastDivision.getSummaryVariance(), (Object)leftPartDivision.divisionIndex);
        LOG.trace("Checking right: {} {} Index: {}", (Object)rightPartDivision.getSummaryVariance(), (Object)lastDivision.getSummaryVariance(), (Object)rightPartDivision.divisionIndex);
        if (leftPartDivision.getSummaryVariance() < rightPartDivision.getSummaryVariance()) {
            LOG.trace("Left smaller");
            if (leftPartDivision.getSummaryVariance() <= lastDivision.getSummaryVariance() && prevIndex != leftPartDivision.divisionIndex) {
                result = Division.getOptimalDivision(values, leftPartDivision, lastMiddleIndex);
            } else {
                LOG.trace("Finally: " + lastDivision.divisionIndex + " " + lastDivision.divisionMeanvalue);
                result = lastDivision;
            }
        } else {
            LOG.trace("Right smaller");
            if (rightPartDivision.getSummaryVariance() <= lastDivision.getSummaryVariance() && prevIndex != rightPartDivision.divisionIndex) {
                result = Division.getOptimalDivision(values, rightPartDivision, lastMiddleIndex);
            } else {
                LOG.trace("Finally: " + lastDivision.divisionIndex + " " + lastDivision.divisionMeanvalue);
                result = lastDivision;
            }
        }
        return result;
    }

    public double getMean() {
        return this.divisionMeanvalue;
    }
}

