/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.statistics.bimodal;

import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.peass.measurement.statistics.bimodal.Division;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IsBimodal {
    private static final Logger LOG = LogManager.getLogger(IsBimodal.class);
    private final SummaryStatistics stat1;
    private final SummaryStatistics stat2;
    private final double avgValue;
    private final double originalVariance;
    private final boolean isBimodal;

    public IsBimodal(double[] values, SummaryStatistics originalStat) {
        Arrays.sort(values);
        Division optimalDivision = Division.getOptimalDivision(values, new Division(values, values.length / 2), values.length);
        this.avgValue = optimalDivision.getMean();
        this.originalVariance = originalStat.getVariance();
        this.stat1 = optimalDivision.statisticCandidate1;
        this.stat2 = optimalDivision.statisticCandidate2;
        this.isBimodal = this.testBimodal();
    }

    public IsBimodal(List<VMResult> fastShortened) {
        double[] values = new double[fastShortened.size()];
        SummaryStatistics originalStat = new SummaryStatistics();
        int i = 0;
        for (VMResult result : fastShortened) {
            values[i++] = result.getValue();
            originalStat.addValue(result.getValue());
        }
        Arrays.sort(values);
        Division optimalDivision = Division.getOptimalDivision(values, new Division(values, values.length / 2), values.length);
        this.avgValue = optimalDivision.getMean();
        this.originalVariance = originalStat.getVariance();
        this.stat1 = optimalDivision.statisticCandidate1;
        this.stat2 = optimalDivision.statisticCandidate2;
        this.isBimodal = this.testBimodal();
    }

    private boolean testBimodal() {
        LOG.trace("Deviations: " + this.stat1.getVariance() + " " + this.stat2.getVariance() + " (" + (this.stat1.getVariance() + this.stat2.getVariance()) + ") vs " + this.originalVariance);
        return this.stat1.getVariance() + this.stat2.getVariance() < this.originalVariance / 2.0 && this.stat1.getN() > 2L && this.stat2.getN() > 2L;
    }

    public double getAvgValue() {
        return this.avgValue;
    }

    public double getOriginalVariance() {
        return this.originalVariance;
    }

    public SummaryStatistics getStat1() {
        return this.stat1;
    }

    public SummaryStatistics getStat2() {
        return this.stat2;
    }

    public boolean isBimodal() {
        return this.isBimodal;
    }
}

