/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.statistics.bimodal;

import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.peass.measurement.dataloading.MultipleVMTestUtil;
import de.dagere.peass.measurement.statistics.bimodal.BimodalityTester;
import de.dagere.peass.measurement.statistics.bimodal.CompareData;
import de.dagere.peass.measurement.statistics.bimodal.IsBimodal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;

public class OutlierRemoverBimodal {
    public OutlierRemoverBimodal(List<VMResult> results) {
        IsBimodal isBimodal = new IsBimodal(results);
        if (isBimodal.isBimodal()) {
            this.removeFromLeftDistribution(results, isBimodal);
            this.removeFromRightDistribution(results, isBimodal);
        } else {
            this.removeUnimodal(results);
        }
    }

    private void removeUnimodal(List<VMResult> results) {
        SummaryStatistics statistics = MultipleVMTestUtil.getStatistic(results);
        Iterator<VMResult> iterator = results.iterator();
        while (iterator.hasNext()) {
            VMResult r = iterator.next();
            double zscore = Math.abs(r.getValue() - statistics.getMean()) / statistics.getStandardDeviation();
            if (!(zscore > 3.29)) continue;
            iterator.remove();
        }
    }

    private void removeFromRightDistribution(List<VMResult> results, IsBimodal isBimodal) {
        SummaryStatistics stat2 = isBimodal.getStat2();
        Iterator<VMResult> iterator = results.iterator();
        while (iterator.hasNext()) {
            double zscore;
            VMResult r = iterator.next();
            if (!(r.getValue() >= isBimodal.getAvgValue()) || !((zscore = Math.abs(r.getValue() - stat2.getMean()) / stat2.getStandardDeviation()) > 3.29)) continue;
            iterator.remove();
        }
    }

    private void removeFromLeftDistribution(List<VMResult> results, IsBimodal isBimodal) {
        SummaryStatistics stat1 = isBimodal.getStat1();
        Iterator<VMResult> iterator = results.iterator();
        while (iterator.hasNext()) {
            double zscore;
            VMResult r = iterator.next();
            if (!(r.getValue() < isBimodal.getAvgValue()) || !((zscore = Math.abs(r.getValue() - stat1.getMean()) / stat1.getStandardDeviation()) > 3.29)) continue;
            iterator.remove();
        }
    }

    public static CompareData removeOutliers(CompareData data, double outlierFactor) {
        BimodalityTester isBismodal = new BimodalityTester(data);
        if (isBismodal.isBimodal()) {
            return OutlierRemoverBimodal.removeOutlierBimodal(data, outlierFactor, isBismodal);
        }
        return OutlierRemoverBimodal.removeOutliersSimple(data, outlierFactor);
    }

    public static CompareData removeOutliersSimple(CompareData data, double outlierFactor) {
        double[] valuesPredecessor = OutlierRemoverBimodal.removeOutliers(data.getPredecessor(), (StatisticalSummary)data.getPredecessorStat(), outlierFactor);
        double[] valuesCurrent = OutlierRemoverBimodal.removeOutliers(data.getCurrent(), (StatisticalSummary)data.getCurrentStat(), outlierFactor);
        CompareData result = new CompareData(valuesPredecessor, valuesCurrent);
        return result;
    }

    private static CompareData removeOutlierBimodal(CompareData data, double outlierFactor, BimodalityTester isBismodal) {
        double[] valuesPredecessor = OutlierRemoverBimodal.removeOutliersBimodal(data.getPredecessor(), isBismodal.getDataPredecessor(), outlierFactor);
        double[] valuesCurrent = OutlierRemoverBimodal.removeOutliersBimodal(data.getCurrent(), isBismodal.getDataAfter(), outlierFactor);
        CompareData result = new CompareData(valuesPredecessor, valuesCurrent);
        return result;
    }

    private static double[] removeOutliersBimodal(double[] values, IsBimodal data, double outlierFactor) {
        ArrayList<Double> containedValues = new ArrayList<Double>(values.length);
        for (double value : values) {
            double zscore;
            if (value < data.getAvgValue()) {
                zscore = Math.abs(value - data.getStat1().getMean()) / data.getStat1().getStandardDeviation();
                if (zscore > outlierFactor) continue;
                containedValues.add(value);
                continue;
            }
            zscore = Math.abs(value - data.getStat2().getMean()) / data.getStat2().getStandardDeviation();
            if (zscore > outlierFactor) continue;
            containedValues.add(value);
        }
        double[] containedResults = ArrayUtils.toPrimitive((Double[])containedValues.toArray(new Double[0]));
        return containedResults;
    }

    private static double[] removeOutliers(double[] original, StatisticalSummary statistics, double outlierFactor) {
        ArrayList<Double> containedValues = new ArrayList<Double>(original.length);
        for (double value : original) {
            double zscore = Math.abs(value - statistics.getMean()) / statistics.getStandardDeviation();
            if (zscore > outlierFactor) continue;
            containedValues.add(value);
        }
        double[] containedResults = ArrayUtils.toPrimitive((Double[])containedValues.toArray(new Double[0]));
        return containedResults;
    }
}

