/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.statistics.data;

import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.kopeme.kopemedata.VMResultChunk;
import de.dagere.peass.config.StatisticsConfig;
import de.dagere.peass.measurement.dataloading.MultipleVMTestUtil;
import de.dagere.peass.measurement.statistics.Relation;
import de.dagere.peass.measurement.statistics.StatisticUtil;
import de.dagere.peass.measurement.statistics.data.OutlierRemover;
import de.dagere.peass.measurement.statistics.data.TestcaseStatistic;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DescribedChunk {
    private static final Logger LOG = LogManager.getLogger(DescribedChunk.class);
    private final DescriptiveStatistics descPrev = new DescriptiveStatistics();
    private final DescriptiveStatistics descCurrent = new DescriptiveStatistics();
    private final List<VMResult> previous = new LinkedList<VMResult>();
    private final List<VMResult> current = new LinkedList<VMResult>();

    public DescribedChunk(VMResultChunk chunk, String commitPrevious, String commitCurrent) {
        long minRepetitions = MultipleVMTestUtil.getMinRepetitionCount(chunk.getResults());
        long minIterations = MultipleVMTestUtil.getMinIterationCount(chunk.getResults());
        LOG.info("Repetitions: " + minRepetitions + " Iterations: " + minIterations);
        for (VMResult result : chunk.getResults()) {
            if (Double.isNaN(result.getValue()) || result.getIterations() != minIterations || result.getRepetitions() != minRepetitions) continue;
            if (result.getCommit().equals(commitPrevious)) {
                this.descPrev.addValue(result.getValue());
                this.previous.add(result);
            }
            if (!result.getCommit().equals(commitCurrent)) continue;
            this.descCurrent.addValue(result.getValue());
            this.current.add(result);
        }
        LOG.trace("Built values: {} {}", (Object)this.previous.size(), (Object)this.current.size());
    }

    public void removeOutliers() {
        OutlierRemover outlierRemover = new OutlierRemover(this);
        outlierRemover.remove();
    }

    public DescriptiveStatistics getDescPrevious() {
        return this.descPrev;
    }

    public DescriptiveStatistics getDescCurrent() {
        return this.descCurrent;
    }

    public List<VMResult> getPrevious() {
        return this.previous;
    }

    public List<VMResult> getCurrent() {
        return this.current;
    }

    public TestcaseStatistic getStatistic(StatisticsConfig config) {
        boolean isChange = StatisticUtil.isDifferent(this.previous, this.current, config) != Relation.EQUAL;
        TestcaseStatistic statistic = new TestcaseStatistic(this.descPrev, this.descCurrent, this.descPrev.getN(), this.descCurrent.getN());
        statistic.setChange(isChange);
        statistic.setIsBimodal(StatisticUtil.isBimodal(this.previous, this.current));
        return statistic;
    }

    public double getDiff() {
        double diff = (this.getDescPrevious().getMean() - this.getDescCurrent().getMean()) * 10000.0 / this.getDescPrevious().getMean() / 100.0;
        return diff;
    }
}

