/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.statistics.data;

import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;

public class EvaluationPair {
    private final String previousCommit;
    private final String currentCommit;
    private final List<VMResult> previous = new LinkedList<VMResult>();
    private final List<VMResult> current = new LinkedList<VMResult>();
    private final TestMethodCall testcase;
    public static final NumberFormat FORMAT = NumberFormat.getInstance();

    public EvaluationPair(String currentCommit, String previousCommit, TestMethodCall testcase) {
        this.currentCommit = currentCommit;
        this.previousCommit = previousCommit;
        this.testcase = testcase;
        if (currentCommit.equals(previousCommit)) {
            throw new RuntimeException("Unexpected behaviour: Previous " + previousCommit + " == Current " + currentCommit + " commit.");
        }
        if (currentCommit == null || previousCommit == null) {
            throw new RuntimeException("Version == null: " + currentCommit + " " + previousCommit + " " + String.valueOf(testcase));
        }
    }

    public TestMethodCall getTestcase() {
        return this.testcase;
    }

    public List<VMResult> getPrevius() {
        return this.previous;
    }

    public List<VMResult> getCurrent() {
        return this.current;
    }

    public void createHistogramFiles(File currentFile, File previousFile) {
        this.printMeans(currentFile, this.current);
        this.printMeans(previousFile, this.previous);
    }

    private void printMeans(File current, List<VMResult> results) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(current));){
            for (VMResult result : results) {
                double value = result.getValue();
                writer.write(FORMAT.format(value) + "\n");
            }
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isComplete() {
        boolean isComplete;
        boolean bl = isComplete = this.previous.size() > 0 && this.previous.size() == this.current.size();
        if (isComplete) {
            isComplete &= this.previous.get(0).getFulldata() != null;
            if (isComplete &= this.current.get(0).getFulldata() != null) {
                isComplete &= this.previous.get(0).getFulldata().getValues().size() > 0;
                isComplete &= this.current.get(0).getFulldata().getValues().size() > 0;
            }
        }
        return isComplete;
    }

    public String getPreviousCommit() {
        return this.previousCommit;
    }

    public String getCommit() {
        return this.currentCommit;
    }

    static {
        FORMAT.setGroupingUsed(false);
    }
}

