/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.statistics.data;

import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.peass.measurement.statistics.data.DescribedChunk;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutlierRemover {
    public static final double Z_SCORE = 3.29;
    private static final Logger LOG = LogManager.getLogger(OutlierRemover.class);
    private final DescribedChunk chunk;

    public OutlierRemover(DescribedChunk chunk) {
        this.chunk = chunk;
    }

    public void remove() {
        RemoveInformation removePrevious = this.removeOutliers(this.chunk.getDescPrevious(), this.chunk.getPrevious());
        RemoveInformation removeCurrent = this.removeOutliers(this.chunk.getDescCurrent(), this.chunk.getCurrent());
        if (removePrevious.getSum() < removeCurrent.getSum()) {
            this.removeFromPrevious(removePrevious, removeCurrent);
        } else if (removeCurrent.getSum() < removePrevious.getSum()) {
            this.removeFromCurrent(removePrevious, removeCurrent);
        }
    }

    private void removeFromPrevious(RemoveInformation removePrevious, RemoveInformation removeCurrent) {
        int additionalRemoves = removeCurrent.getSum() - removePrevious.getSum();
        while (additionalRemoves > 0) {
            if (removePrevious.removedHigher < removeCurrent.removedHigher) {
                this.removeByValue(this.chunk.getDescPrevious(), this.chunk.getPrevious(), this.chunk.getDescPrevious().getMax());
                ++removePrevious.removedHigher;
            } else if (removePrevious.removedLower < removeCurrent.removedLower) {
                this.removeByValue(this.chunk.getDescPrevious(), this.chunk.getPrevious(), this.chunk.getDescPrevious().getMin());
                ++removePrevious.removedLower;
            }
            additionalRemoves = removeCurrent.getSum() - removePrevious.getSum();
        }
    }

    private void removeFromCurrent(RemoveInformation removePrevious, RemoveInformation removeCurrent) {
        int additionalRemoves = removePrevious.getSum() - removeCurrent.getSum();
        while (additionalRemoves > 0) {
            if (removeCurrent.removedHigher < removePrevious.removedHigher) {
                this.removeByValue(this.chunk.getDescCurrent(), this.chunk.getCurrent(), this.chunk.getDescCurrent().getMax());
                ++removeCurrent.removedHigher;
            } else if (removeCurrent.removedLower < removePrevious.removedLower) {
                this.removeByValue(this.chunk.getDescCurrent(), this.chunk.getCurrent(), this.chunk.getDescCurrent().getMin());
                ++removeCurrent.removedLower;
            }
            additionalRemoves = removeCurrent.getSum() - removePrevious.getSum();
        }
    }

    private void removeByValue(DescriptiveStatistics statistics, List<VMResult> results, double value) {
        Iterator<VMResult> it = results.iterator();
        while (it.hasNext()) {
            VMResult result = it.next();
            if (result.getValue() != value) continue;
            LOG.debug("Removing Value: {}", (Object)result.getValue());
            it.remove();
            break;
        }
        this.rebuildStatistics(statistics, results);
    }

    private RemoveInformation removeOutliers(DescriptiveStatistics statistics, List<VMResult> results) {
        RemoveInformation removals = new RemoveInformation();
        double max = statistics.getMean() + 3.29 * statistics.getStandardDeviation();
        double min = statistics.getMean() - 3.29 * statistics.getStandardDeviation();
        int outliers = this.countOutliers(results, max, min);
        double allowedOutliers = (double)results.size() * 0.05;
        LOG.info("Outliers: {} Allowed: {} Values: {}", (Object)outliers, (Object)allowedOutliers, (Object)results.size());
        LOG.debug("Mean: {} Max: {} Min: {}", (Object)statistics.getMean(), (Object)max, (Object)min);
        if ((double)outliers < allowedOutliers) {
            this.removeFromList(results, removals, max, min);
            this.rebuildStatistics(statistics, results);
        }
        return removals;
    }

    private void removeFromList(List<VMResult> results, RemoveInformation removals, double max, double min) {
        Iterator<VMResult> it = results.iterator();
        while (it.hasNext()) {
            VMResult result = it.next();
            if (result.getValue() > max) {
                LOG.debug("Removing: {}", (Object)result.getValue());
                it.remove();
                ++removals.removedHigher;
            }
            if (!(result.getValue() < min)) continue;
            LOG.debug("Removing: {}", (Object)result.getValue());
            it.remove();
            ++removals.removedLower;
        }
    }

    private int countOutliers(List<VMResult> results, double max, double min) {
        int outliers = 0;
        for (VMResult result : results) {
            if (!(result.getValue() > max) && !(result.getValue() < min)) continue;
            ++outliers;
        }
        return outliers;
    }

    private void rebuildStatistics(DescriptiveStatistics statistics, List<VMResult> results) {
        statistics.clear();
        for (VMResult result : results) {
            statistics.addValue(result.getValue());
        }
    }

    class RemoveInformation {
        int removedHigher = 0;
        int removedLower = 0;

        RemoveInformation() {
        }

        public int getSum() {
            return this.removedHigher + this.removedLower;
        }
    }
}

