/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.statistics.data;

import de.dagere.peass.config.StatisticsConfig;
import de.dagere.peass.measurement.rca.data.OneVMResult;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutlierRemoverVMResults {
    private static final Logger LOG = LogManager.getLogger(OutlierRemoverVMResults.class);

    public static void getValuesWithoutOutliers(List<OneVMResult> results, SummaryStatistics statistics, StatisticsConfig config) {
        if (config.getOutlierFactor() != 0.0 && results.size() > 1) {
            SummaryStatistics fullStatistic = new SummaryStatistics();
            OutlierRemoverVMResults.addAll(results, fullStatistic);
            double min = fullStatistic.getMean() - config.getOutlierFactor() * fullStatistic.getStandardDeviation();
            double max = fullStatistic.getMean() + config.getOutlierFactor() * fullStatistic.getStandardDeviation();
            LOG.debug("Removing outliers that are not between {} and {} - Old vm count: {}", (Object)min, (Object)max, (Object)results.size());
            OutlierRemoverVMResults.addNonOutlier(results, statistics, min, max);
            LOG.debug("Final VM count: {}", (Object)statistics.getN());
        } else {
            OutlierRemoverVMResults.addAll(results, statistics);
        }
    }

    private static void addNonOutlier(List<OneVMResult> results, SummaryStatistics statistics, double min, double max) {
        for (OneVMResult result : results) {
            double average = result.getAverage();
            if (average >= min && average <= max) {
                statistics.addValue(average);
                LOG.trace("Adding value: {}", (Object)average);
                continue;
            }
            LOG.debug("Not adding outlier: {}", (Object)average);
        }
    }

    private static void addAll(List<OneVMResult> results, SummaryStatistics statistics) {
        for (OneVMResult result : results) {
            if (Double.isNaN(result.getAverage())) continue;
            double average = result.getAverage();
            statistics.addValue(average);
        }
    }
}

