/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.statistics.data;

import de.dagere.kopeme.kopemedata.Kopemedata;
import de.dagere.kopeme.kopemedata.VMResult;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.dependencyprocessors.CommitComparatorInstance;
import de.dagere.peass.measurement.statistics.data.EvaluationPair;
import java.io.File;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestData {
    private static final Logger LOG = LogManager.getLogger(TestData.class);
    private final TestMethodCall testcase;
    private final File origin;
    private final SortedMap<String, EvaluationPair> data;

    public TestData(TestMethodCall testcase, File origin, CommitComparatorInstance comparator) {
        this.testcase = testcase;
        this.origin = origin;
        this.data = new TreeMap<String, EvaluationPair>((Comparator<String>)comparator);
    }

    public void addMeasurement(String commitOfPair, String currentCommit, String predecessor, Kopemedata resultData) {
        LOG.trace("Pair-Commit: {} Class: {} Method: {}", (Object)commitOfPair, (Object)this.testcase.getClazz(), (Object)this.testcase.getMethod());
        EvaluationPair currentPair = (EvaluationPair)this.data.get(commitOfPair);
        if (currentPair == null) {
            LOG.debug("Commit: {} Predecessor: {}", (Object)commitOfPair, (Object)predecessor);
            if (commitOfPair != null) {
                currentPair = new EvaluationPair(commitOfPair, predecessor, new TestMethodCall(resultData));
                this.data.put(commitOfPair, currentPair);
            }
        }
        if (currentPair != null) {
            VMResult result = resultData.getFirstResult();
            if (commitOfPair.equals(currentCommit)) {
                currentPair.getCurrent().add(result);
            } else {
                currentPair.getPrevius().add(result);
            }
        }
    }

    public SortedMap<String, EvaluationPair> getMeasurements() {
        return this.data;
    }

    public String getTestClass() {
        return this.testcase.getClazz();
    }

    public String getTestMethod() {
        return this.testcase.getMethodWithParams();
    }

    public int getVersions() {
        return this.data.size();
    }

    public TestMethodCall getTestCase() {
        return this.testcase;
    }

    public File getOrigin() {
        return this.origin;
    }
}

