/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.statistics.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import de.dagere.peass.measurement.statistics.StatisticUtil;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.StatisticalSummary;
import org.apache.commons.math3.stat.descriptive.StatisticalSummaryValues;
import org.apache.commons.math3.stat.inference.TestUtils;

public class TestcaseStatistic {
    private double meanOld;
    private double meanCurrent;
    private double deviationOld;
    private double deviationCurrent;
    private long vms;
    private long callsOld;
    private long calls;
    private double tvalue;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double mannWhitneyUStatistic = null;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String predecessor;
    private Boolean isChange;
    private Boolean isBimodal;

    public TestcaseStatistic() {
    }

    public TestcaseStatistic(DescriptiveStatistics statisticsOld, DescriptiveStatistics statisticsCurrent, long callsOld, long calls) {
        boolean oldHasValues = statisticsOld != null && statisticsOld.getN() > 0L;
        boolean currentHasValues = statisticsCurrent != null && statisticsCurrent.getN() > 0L;
        this.meanCurrent = currentHasValues ? statisticsCurrent.getMean() : Double.NaN;
        this.meanOld = oldHasValues ? statisticsOld.getMean() : Double.NaN;
        this.deviationCurrent = currentHasValues ? statisticsCurrent.getStandardDeviation() : Double.NaN;
        double d = this.deviationOld = oldHasValues ? statisticsOld.getStandardDeviation() : Double.NaN;
        this.vms = currentHasValues && oldHasValues ? (statisticsCurrent.getN() + statisticsOld.getN()) / 2L : (oldHasValues ? statisticsOld.getN() : (currentHasValues ? statisticsCurrent.getN() : 0L));
        this.tvalue = oldHasValues && currentHasValues ? TestUtils.t((StatisticalSummary)statisticsOld, (StatisticalSummary)statisticsCurrent) : -1.0;
        this.mannWhitneyUStatistic = oldHasValues && currentHasValues ? StatisticUtil.getMannWhitneyUStatistic(statisticsOld, statisticsCurrent) : null;
        this.isChange = null;
        this.calls = calls;
        this.callsOld = callsOld;
        this.check();
    }

    public TestcaseStatistic(StatisticalSummary statisticsOld, StatisticalSummary statisticsCurrent, long callsOld, long calls) {
        boolean oldHasValues = statisticsOld != null && statisticsOld.getN() > 0L;
        boolean currentHasValues = statisticsCurrent != null && statisticsCurrent.getN() > 0L;
        this.meanCurrent = currentHasValues ? statisticsCurrent.getMean() : Double.NaN;
        this.meanOld = oldHasValues ? statisticsOld.getMean() : Double.NaN;
        this.deviationCurrent = currentHasValues ? statisticsCurrent.getStandardDeviation() : Double.NaN;
        double d = this.deviationOld = oldHasValues ? statisticsOld.getStandardDeviation() : Double.NaN;
        this.vms = currentHasValues && oldHasValues ? (statisticsCurrent.getN() + statisticsOld.getN()) / 2L : (oldHasValues ? statisticsOld.getN() : (currentHasValues ? statisticsCurrent.getN() : 0L));
        this.tvalue = oldHasValues && currentHasValues ? TestUtils.t((StatisticalSummary)statisticsOld, (StatisticalSummary)statisticsCurrent) : -1.0;
        this.isChange = null;
        this.calls = calls;
        this.callsOld = callsOld;
        this.check();
    }

    public TestcaseStatistic(double meanOld, double meanCurrent, double deviationOld, double deviationCurrent, long executions, double tvalue, double mannWhitneyUStatistic, boolean isChange, long callsOld, long calls) {
        this.meanOld = meanOld;
        this.meanCurrent = meanCurrent;
        this.deviationOld = deviationOld;
        this.deviationCurrent = deviationCurrent;
        this.vms = executions;
        this.tvalue = tvalue;
        this.mannWhitneyUStatistic = mannWhitneyUStatistic;
        this.isChange = isChange;
        this.calls = calls;
        this.callsOld = callsOld;
        this.check();
    }

    private void check() {
        if (!(this.callsOld != 0L || Double.isNaN(this.meanOld) && Double.isNaN(this.deviationOld))) {
            throw new TestcaseStatisticException("Old data need to be not defined at all or contain a count of calls, a mean and a deviation, but was " + this.callsOld + " calls, " + this.meanOld + " mean and " + this.deviationOld + " deviation!");
        }
        if (!(this.calls != 0L || Double.isNaN(this.meanCurrent) && Double.isNaN(this.deviationCurrent))) {
            throw new TestcaseStatisticException("Current data need to be not defined at all or contain a count of calls, a mean and a deviation, but was " + this.calls + " calls, " + this.meanCurrent + " mean and " + this.deviationCurrent + " deviation!");
        }
    }

    public String getPredecessor() {
        return this.predecessor;
    }

    public void setPredecessor(String predecessor) {
        this.predecessor = predecessor;
    }

    public double getMeanOld() {
        return this.meanOld;
    }

    public void setMeanOld(double mean1) {
        this.meanOld = mean1;
    }

    public double getMeanCurrent() {
        return this.meanCurrent;
    }

    public void setMeanCurrent(double mean2) {
        this.meanCurrent = mean2;
    }

    public double getDeviationOld() {
        return this.deviationOld;
    }

    public void setDeviationOld(double deviation1) {
        this.deviationOld = deviation1;
    }

    public double getDeviationCurrent() {
        return this.deviationCurrent;
    }

    public void setDeviationCurrent(double deviation2) {
        this.deviationCurrent = deviation2;
    }

    public long getCallsOld() {
        return this.callsOld;
    }

    public void setCallsOld(long callsOld) {
        this.callsOld = callsOld;
    }

    public long getCalls() {
        return this.calls;
    }

    public void setCalls(long calls) {
        this.calls = calls;
    }

    public long getVMs() {
        return this.vms;
    }

    public void setVMs(long vms) {
        this.vms = vms;
    }

    public double getTvalue() {
        return this.tvalue;
    }

    public void setTvalue(double tvalue) {
        this.tvalue = tvalue;
    }

    public Double getMannWhitneyUStatistic() {
        return this.mannWhitneyUStatistic;
    }

    public void setMannWhitneyUStatistic(Double mannWhitneyUStatistic) {
        this.mannWhitneyUStatistic = mannWhitneyUStatistic;
    }

    public String toString() {
        return this.meanOld + " " + this.meanCurrent + " " + this.deviationOld / this.meanOld + " " + this.deviationCurrent / this.meanCurrent + " " + this.vms + " " + this.tvalue;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean isChange() {
        return this.isChange;
    }

    public void setChange(Boolean isChange) {
        this.isChange = isChange;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIsBimodal() {
        return this.isBimodal;
    }

    public void setIsBimodal(Boolean isBimodal) {
        this.isBimodal = isBimodal;
    }

    @JsonIgnore
    public StatisticalSummary getStatisticsCurrent() {
        return new StatisticalSummaryValues(this.meanCurrent, this.deviationCurrent * this.deviationCurrent, this.vms, Double.MAX_VALUE, 0.0, this.meanCurrent * (double)this.vms);
    }

    @JsonIgnore
    public StatisticalSummary getStatisticsOld() {
        return new StatisticalSummaryValues(this.meanOld, this.deviationOld * this.deviationOld, this.vms, Double.MAX_VALUE, 0.0, this.meanOld * (double)this.vms);
    }

    public static final class TestcaseStatisticException
    extends RuntimeException {
        private static final long serialVersionUID = 1568505424388144454L;

        public TestcaseStatisticException(String message) {
            super(message);
        }
    }
}

