/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.utils;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.JsonMappingException;
import de.dagere.nodeDiffDetector.data.TestClazzCall;
import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.analysis.changes.Changes;
import de.dagere.peass.analysis.changes.ProjectChanges;
import de.dagere.peass.analysis.measurement.ProjectStatistics;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.config.parameters.ExecutionConfigMixin;
import de.dagere.peass.config.parameters.KiekerConfigMixin;
import de.dagere.peass.config.parameters.MeasurementConfigurationMixin;
import de.dagere.peass.config.parameters.StatisticsConfigMixin;
import de.dagere.peass.dependency.analysis.data.TestSet;
import de.dagere.peass.dependency.persistence.CommitStaticSelection;
import de.dagere.peass.dependency.persistence.ExecutionData;
import de.dagere.peass.dependency.persistence.SelectedTests;
import de.dagere.peass.dependency.persistence.StaticTestSelection;
import de.dagere.peass.measurement.rca.data.CauseSearchData;
import de.dagere.peass.measurement.statistics.data.TestcaseStatistic;
import de.dagere.peass.measurement.utils.RunCommandWriter;
import de.dagere.peass.measurement.utils.RunCommandWriterRCA;
import de.dagere.peass.measurement.utils.RunCommandWriterSlurm;
import de.dagere.peass.utils.Constants;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(description={"Creates a script (bash or slurm) to run a set of tests"}, name="createScript")
public class CreateScriptStarter
implements Callable<Void> {
    @CommandLine.Option(names={"-experimentId", "--experimentId"}, description={"Id of the experiment"})
    protected String experimentId = "default";
    @CommandLine.Option(names={"-staticSelectionFile", "--staticSelectionFile"}, description={"Path to the static test selection file"})
    protected File staticSelectionFile;
    @CommandLine.Option(names={"-executionFile", "--executionFile"}, description={"Path to the executionfile"})
    protected File executionFile;
    @CommandLine.Option(names={"-changeFile", "--changeFile"}, description={"Path to the change file"})
    protected File[] changeFile;
    @CommandLine.Option(names={"-statisticsFile", "--statisticsFile"}, description={"Path to the statistics file"})
    protected File[] statisticsFile;
    @CommandLine.Option(names={"-alreadyFinishedFolder", "--alreadyFinishedFolder"}, description={"Path to folder where finished results are (each should be named treeMeasurementResults)"})
    protected File[] alreadyFinishedFolder;
    @CommandLine.Option(names={"-useSlurm", "--useSlurm"}, description={"Use slurm (if not specified, a bash script is created)"})
    protected Boolean useSlurm = false;
    @CommandLine.Mixin
    MeasurementConfigurationMixin measurementConfigMixin;
    @CommandLine.Mixin
    ExecutionConfigMixin executionConfigMixin;
    private StaticTestSelection staticTestSelection;
    private ExecutionData executionData;
    private Map<String, List<String>> alreadyAnalyzed = new HashMap<String, List<String>>();

    public static void main(String[] args) throws JsonParseException, JsonMappingException, IOException {
        CreateScriptStarter command = new CreateScriptStarter();
        CommandLine commandLine = new CommandLine((Object)command);
        commandLine.execute(args);
    }

    @Override
    public Void call() throws Exception {
        if (this.staticSelectionFile != null) {
            this.staticTestSelection = (StaticTestSelection)Constants.OBJECTMAPPER.readValue(this.staticSelectionFile, StaticTestSelection.class);
        }
        if (this.executionFile != null) {
            this.executionData = (ExecutionData)Constants.OBJECTMAPPER.readValue(this.executionFile, ExecutionData.class);
            this.staticTestSelection = new StaticTestSelection(this.executionData);
        }
        if (this.executionData == null && this.staticTestSelection == null) {
            throw new RuntimeException("StaticSelectionFile and executionFile not readable - one needs to be defined!");
        }
        MeasurementConfig config = new MeasurementConfig(this.measurementConfigMixin, this.executionConfigMixin, new StatisticsConfigMixin(), new KiekerConfigMixin());
        PrintStream destination = System.out;
        if (this.alreadyFinishedFolder != null) {
            this.determineMeasuredTestCommitPairs();
        }
        if (this.changeFile == null) {
            this.generateMeasurementExecuteCommands(config, destination);
        } else {
            this.generateRCAExecuteCommands(config, destination);
        }
        return null;
    }

    private void determineMeasuredTestCommitPairs() throws IOException, StreamReadException, DatabindException {
        for (File folder : this.alreadyFinishedFolder) {
            for (File commitFolder : folder.listFiles()) {
                for (File testclazzFolder : commitFolder.listFiles()) {
                    for (File resultFile : testclazzFolder.listFiles()) {
                        if (resultFile.isDirectory()) continue;
                        CauseSearchData csd = (CauseSearchData)Constants.OBJECTMAPPER.readValue(resultFile, CauseSearchData.class);
                        String commit = csd.getMeasurementConfig().getFixedCommitConfig().getCommit();
                        List<String> finishedTests = this.alreadyAnalyzed.get(commit);
                        if (finishedTests == null) {
                            finishedTests = new LinkedList<String>();
                            this.alreadyAnalyzed.put(commit, finishedTests);
                        }
                        finishedTests.add(csd.getTestcase());
                    }
                }
            }
        }
    }

    private void generateMeasurementExecuteCommands(MeasurementConfig config, PrintStream destination) throws IOException, StreamReadException, DatabindException {
        RunCommandWriter writer;
        if (this.useSlurm.booleanValue()) {
            destination.println("timestamp=$(date +%s)");
            writer = new RunCommandWriterSlurm(config, System.out, this.experimentId, (SelectedTests)this.staticTestSelection);
        } else {
            writer = new RunCommandWriter(config, destination, this.experimentId, (SelectedTests)this.staticTestSelection);
        }
        if (this.statisticsFile != null) {
            for (File statisticFile : this.statisticsFile) {
                ProjectStatistics statistics = (ProjectStatistics)Constants.OBJECTMAPPER.readValue(statisticFile, ProjectStatistics.class);
                for (Map.Entry<String, Map<TestMethodCall, TestcaseStatistic>> commitEntry : statistics.getStatistics().entrySet()) {
                    String commit = commitEntry.getKey();
                    for (Map.Entry<TestMethodCall, TestcaseStatistic> methodCallEntry : commitEntry.getValue().entrySet()) {
                        TestMethodCall methodCall = methodCallEntry.getKey();
                        TestSet currentCommitTestSet = (TestSet)this.executionData.getCommits().get(commit);
                        currentCommitTestSet.removeTest(methodCall.onlyClazz(), methodCall.getMethod());
                    }
                }
            }
        }
        this.generateExecuteCommands(this.staticTestSelection, this.executionData, this.experimentId, writer);
    }

    private void generateRCAExecuteCommands(MeasurementConfig config, PrintStream destination) throws IOException, StreamReadException, DatabindException {
        ExecutionData mergedExecutions = this.mergeChangeExecutions();
        RunCommandWriterRCA writer = new RunCommandWriterRCA(config, destination, this.experimentId, (SelectedTests)mergedExecutions);
        this.generateExecuteCommands(this.staticTestSelection, mergedExecutions, this.experimentId, writer);
    }

    private ExecutionData mergeChangeExecutions() throws IOException, StreamReadException, DatabindException {
        ExecutionData mergedExecutions = new ExecutionData();
        mergedExecutions.setUrl(this.executionData.getUrl());
        for (Map.Entry commit : this.executionData.getCommits().entrySet()) {
            mergedExecutions.addEmptyCommit((String)commit.getKey(), ((TestSet)commit.getValue()).getPredecessor());
        }
        for (File changeFileEntry : this.changeFile) {
            ProjectChanges changes = (ProjectChanges)Constants.OBJECTMAPPER.readValue(changeFileEntry, ProjectChanges.class);
            for (Map.Entry<String, Changes> changeEntry : changes.getCommitChanges().entrySet()) {
                String commit = changeEntry.getKey();
                TestSet tests = changeEntry.getValue().getTests();
                mergedExecutions.addCall(commit, tests);
            }
        }
        return mergedExecutions;
    }

    public void generateExecuteCommands(StaticTestSelection dependencies, ExecutionData changedTests, String experimentId, PrintStream goal) throws IOException {
        this.generateExecuteCommands(dependencies, changedTests, experimentId, new RunCommandWriterSlurm(new MeasurementConfig(30), goal, experimentId, (SelectedTests)dependencies));
    }

    public static void generateExecuteCommands(ExecutionData changedTests, String experimentId, PrintStream goal) throws IOException {
        CreateScriptStarter.generateExecuteCommands(changedTests, experimentId, new RunCommandWriterSlurm(new MeasurementConfig(30), goal, experimentId, (SelectedTests)changedTests));
    }

    public static void generateExecuteCommands(ExecutionData changedTests, String experimentId, RunCommandWriter writer) throws IOException {
        int i = 0;
        for (Map.Entry entry : changedTests.getCommits().entrySet()) {
            for (Map.Entry testcase : ((TestSet)entry.getValue()).getTestcases().entrySet()) {
                for (String method : (Set)testcase.getValue()) {
                    String testcaseName = ((TestClazzCall)testcase.getKey()).getClazz() + "#" + method;
                    writer.createSingleMethodCommand(i, (String)entry.getKey(), testcaseName);
                }
            }
            ++i;
        }
    }

    public void generateExecuteCommands(StaticTestSelection dependencies, ExecutionData changedTests, String experimentId, RunCommandWriter writer) throws IOException {
        String[] commits = dependencies.getCommitNames();
        for (int commitIndex = 0; commitIndex < commits.length; ++commitIndex) {
            String endcommit = commits[commitIndex];
            if (changedTests == null) {
                Set tests = ((CommitStaticSelection)dependencies.getCommits().get(endcommit)).getTests().getTestMethods();
                writer.createFullVersionCommand(commitIndex, endcommit, tests);
                continue;
            }
            if (changedTests == null || !changedTests.getCommits().containsKey(endcommit)) continue;
            for (Map.Entry testcase : ((TestSet)changedTests.getCommits().get(endcommit)).getTestcases().entrySet()) {
                for (String method : (Set)testcase.getValue()) {
                    String testcaseName = ((TestClazzCall)testcase.getKey()).getClazz() + "#" + method;
                    List<String> alreadyAnalyzedTests = this.alreadyAnalyzed.get(endcommit);
                    boolean analyzed = false;
                    if (alreadyAnalyzedTests != null && alreadyAnalyzedTests.contains(testcaseName)) {
                        analyzed = true;
                    }
                    if (analyzed) continue;
                    writer.createSingleMethodCommand(commitIndex, endcommit, testcaseName);
                }
            }
        }
    }
}

