/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.utils;

import de.dagere.nodeDiffDetector.data.TestMethodCall;
import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.persistence.SelectedTests;
import java.io.PrintStream;
import java.util.Set;

public class RunCommandWriter {
    public static final String DEFAULT_PROJECT_FOLDER_LOCATION = "../projects/";
    protected final PrintStream goal;
    protected final String experimentId;
    protected String name;
    protected String url;
    protected int nice = 1000000;
    protected MeasurementConfig config;

    public RunCommandWriter(MeasurementConfig config, PrintStream goal, String experimentId, SelectedTests dependencies) {
        this.config = config;
        this.goal = goal;
        this.experimentId = experimentId;
        if (dependencies.getUrl() == null) {
            throw new RuntimeException("Run commands can only be created if URL for download is present!");
        }
        this.name = dependencies.getName();
        this.url = dependencies.getUrl();
    }

    public RunCommandWriter(PrintStream goal, String experimentId, String name, String url) {
        this.goal = goal;
        this.experimentId = experimentId;
        this.name = name;
        this.url = url;
    }

    public void setNice(int nice) {
        this.nice = nice;
    }

    public void createFullVersionCommand(int commitIndex, String commit, Set<TestMethodCall> tests) {
        for (TestMethodCall testcase : tests) {
            String testcaseName = testcase.toString();
            this.createSingleMethodCommand(commitIndex, commit, testcaseName);
        }
    }

    public MeasurementConfig getConfig() {
        return this.config;
    }

    public void createSingleMethodCommand(int commitIndex, String commit, String testcaseName) {
        Object usableTestcaseName;
        String measurementFileName;
        if (testcaseName.contains(" ") || testcaseName.contains("(")) {
            measurementFileName = "\"measurement_" + commit.substring(0, 6) + "_" + testcaseName + ".txt\"";
            usableTestcaseName = "\"" + testcaseName + "\"";
        } else {
            measurementFileName = "measurement_" + commit.substring(0, 6) + "_" + testcaseName + ".txt";
            usableTestcaseName = testcaseName;
        }
        this.goal.println("./peass measure -test " + (String)usableTestcaseName + " -warmup " + this.config.getWarmup() + " -iterations " + this.config.getIterations() + " -repetitions " + this.config.getRepetitions() + " -vms " + this.config.getVms() + " -timeout " + this.config.getTimeoutInSeconds() / 60L + " -measurementStrategy " + String.valueOf(this.config.getMeasurementStrategy()) + " " + (this.config.getExecutionConfig().isExcludeLog4jToSlf4j() ? "-excludeLog4jToSlf4j " : "") + (this.config.getExecutionConfig().isExcludeLog4jSlf4jImpl() ? "-excludeLog4jSlf4jImpl " : "") + (this.config.getExecutionConfig().isShowStart() ? "-showStart " : "") + (!this.config.getExecutionConfig().isRedirectToNull() ? "-dontRedirectToNull " : "") + (this.config.isDirectlyMeasureKieker() ? "-directlyMeasureKieker " : "") + "-commit " + commit + " -executionFile results/traceTestSelection_" + this.name + ".json -folder ../projects/" + this.name + "/  &> " + measurementFileName);
    }
}

