/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.utils;

import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.persistence.SelectedTests;
import de.dagere.peass.measurement.rca.RCAStrategy;
import de.dagere.peass.measurement.utils.RunCommandWriter;
import java.io.PrintStream;

public class RunCommandWriterRCA
extends RunCommandWriter {
    public RunCommandWriterRCA(MeasurementConfig config, PrintStream goal, String experimentId, SelectedTests dependencies) {
        super(config, goal, experimentId, dependencies);
    }

    @Override
    public void createSingleMethodCommand(int versionIndex, String commit, String testcaseName) {
        Object usableTestcaseName;
        String measurementFileName;
        long timeoutInMinutes = this.config.getTimeoutInSeconds() / 60L;
        if (testcaseName.contains(" ") || testcaseName.contains("(")) {
            measurementFileName = "\"measurement_" + commit.substring(0, 6) + "_" + testcaseName + ".txt\"";
            usableTestcaseName = "\"" + testcaseName + "\"";
        } else {
            measurementFileName = "measurement_" + commit.substring(0, 6) + "_" + testcaseName + ".txt";
            usableTestcaseName = testcaseName;
        }
        this.goal.println("./peass searchcause -rcaStrategy " + String.valueOf((Object)RCAStrategy.UNTIL_SOURCE_CHANGE) + " -propertyFolder results/properties_" + this.name + " -test " + (String)usableTestcaseName + " -warmup " + this.config.getWarmup() + " -iterations " + this.config.getIterations() + " -repetitions " + this.config.getRepetitions() + " -vms " + this.config.getVms() + " -timeout " + timeoutInMinutes + " -type1error 0.2 -type2error 0.1 -measurementStrategy " + String.valueOf(this.config.getMeasurementStrategy()) + " " + (this.config.getExecutionConfig().isExcludeLog4jToSlf4j() ? "-excludeLog4jToSlf4j " : "") + (this.config.getExecutionConfig().isExcludeLog4jSlf4jImpl() ? "-excludeLog4jSlf4jImpl " : "") + "-commit " + commit + " -folder ../projects/" + this.name + "/ -executionFile results/traceTestSelection_" + this.name + ".json  &> " + measurementFileName);
    }
}

