/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.utils;

import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.persistence.SelectedTests;
import de.dagere.peass.measurement.utils.RunCommandWriter;
import java.io.PrintStream;

public class RunCommandWriterSlurm
extends RunCommandWriter {
    public static final String EXECUTE_MEASUREMENT = "executeTests.sh";
    public static final String EXECUTE_RCA = "executeRCA.sh";
    private static final String HOME_FOLDER = "/home/sc.uni-leipzig.de/do820mize";
    boolean inited = false;
    private final String script;
    private final String slurmOutputFolder;

    public RunCommandWriterSlurm(MeasurementConfig config, PrintStream goal, String experimentId, SelectedTests dependencies) {
        this(config, goal, experimentId, dependencies, EXECUTE_MEASUREMENT);
    }

    public RunCommandWriterSlurm(MeasurementConfig config, PrintStream goal, String experimentId, SelectedTests dependencies, String script) {
        super(config, goal, experimentId, dependencies);
        this.slurmOutputFolder = "/home/sc.uni-leipzig.de/do820mize/processlogs/" + dependencies.getName();
        this.script = script;
    }

    public RunCommandWriterSlurm(PrintStream goal, String experimentId, String name, String url) {
        super(goal, experimentId, name, url);
        this.slurmOutputFolder = "/home/sc.uni-leipzig.de/do820mize/processlogs/" + name;
        this.script = EXECUTE_MEASUREMENT;
    }

    public void init() {
        this.goal.println("timestamp=$(date +%s)");
        this.goal.println("mkdir -p " + this.slurmOutputFolder);
    }

    @Override
    public void createSingleMethodCommand(int versionIndex, String endversion, String testcaseName) {
        if (!this.inited) {
            this.init();
            this.inited = true;
        }
        String simpleTestName = testcaseName.substring(testcaseName.lastIndexOf(46) + 1);
        this.goal.println("sbatch --partition=galaxy-low-prio --nice=" + this.nice + " --time=10-0 --output=" + this.slurmOutputFolder + "/" + versionIndex + "_" + simpleTestName + "_$timestamp.out --export=PROJECT=" + this.url + ",HOME=/home/sc.uni-leipzig.de/do820mize,START=" + endversion + ",END=" + endversion + ",INDEX=" + versionIndex + ",EXPERIMENT_ID=" + this.experimentId + ",TEST=" + testcaseName + " " + this.script);
    }
}

