/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.peass.measurement.utils;

import de.dagere.peass.config.MeasurementConfig;
import de.dagere.peass.dependency.persistence.SelectedTests;
import de.dagere.peass.measurement.utils.RunCommandWriter;
import java.io.PrintStream;

public class RunCommandWriterSlurmRCA
extends RunCommandWriter {
    public static final String EXECUTE_RCA = "executeRCA.sh";
    boolean inited = false;
    private final String script;
    private final String slurmOutputFolder;

    public RunCommandWriterSlurmRCA(MeasurementConfig config, PrintStream goal, String experimentId, SelectedTests dependencies) {
        this(config, goal, experimentId, dependencies, EXECUTE_RCA);
    }

    public RunCommandWriterSlurmRCA(MeasurementConfig config, PrintStream goal, String experimentId, SelectedTests dependencies, String script) {
        super(config, goal, experimentId, dependencies);
        this.slurmOutputFolder = "/nfs/user/do820mize/rcalogs/" + dependencies.getName();
        this.script = script;
    }

    public RunCommandWriterSlurmRCA(PrintStream goal, String experimentId, String name, String url) {
        super(goal, experimentId, name, url);
        this.slurmOutputFolder = "/nfs/user/do820mize/rcalogs/" + name;
        this.script = EXECUTE_RCA;
    }

    public void init() {
        this.goal.println("timestamp=$(date +%s)");
        this.goal.println("mkdir -p " + this.slurmOutputFolder);
    }

    public void createSingleMethodCommand(int versionIndex, String endversion, String testcaseName, int iterations, int repetitions, int vms) {
        if (!this.inited) {
            this.init();
            this.inited = true;
        }
        String simpleTestName = testcaseName.substring(testcaseName.lastIndexOf(46) + 1);
        this.goal.println("sbatch --partition=galaxy-low-prio --nice=" + this.nice + " --time=10-0 --output=" + this.slurmOutputFolder + "/" + versionIndex + "_" + simpleTestName + "_$timestamp.out --export=PROJECT=" + this.url + ",HOME=/nfs/user/do820mize,START=" + endversion + ",END=" + endversion + ",INDEX=" + versionIndex + ",ITERATIONS=" + iterations + ",REPETITIONS=" + repetitions + ",VMS=" + vms + ",EXPERIMENT_ID=" + this.experimentId + ",TEST=" + testcaseName + " " + this.script);
    }
}

