/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.requitur;

import de.dagere.requitur.Digram;
import de.dagere.requitur.Rule;
import de.dagere.requitur.Sequitur;
import de.dagere.requitur.Symbol;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExistingRuleMarker {
    private static final Logger LOG = LogManager.getLogger(ExistingRuleMarker.class);
    private final Sequitur sequitur;
    private final Map<Digram, Rule> currentRules = new HashMap<Digram, Rule>();
    private final Map<Digram, Digram> replacedDigrams = new HashMap<Digram, Digram>();

    public ExistingRuleMarker(Sequitur sequitur) {
        this.sequitur = sequitur;
    }

    public void mark() {
        this.detectDigrams();
        this.sequitur.digrams = this.replacedDigrams;
        Symbol iterator = this.sequitur.getStartSymbol().getSuccessor();
        while (iterator != null && iterator.getValue() != null && iterator.getSuccessor() != null) {
            Symbol successor = iterator.getSuccessor();
            Digram digram = new Digram(iterator, successor);
            Rule potentialRule = this.currentRules.get(digram);
            if (potentialRule != null) {
                this.markRule(digram, potentialRule);
            }
            iterator = successor;
        }
    }

    private void markRule(Digram digram, Rule potentialRule) {
        LOG.trace("Reusing: " + potentialRule.getName() + " " + potentialRule.getElements());
        Symbol ruleSymbol = new Symbol(this.sequitur, potentialRule);
        digram.getStart().getPredecessor().setSuccessor(ruleSymbol);
        ruleSymbol.setPredecessor(digram.getStart().getPredecessor());
        if (digram.getEnd().getSuccessor() != null) {
            digram.getEnd().getSuccessor().setPredecessor(ruleSymbol);
            ruleSymbol.setSuccessor(digram.getEnd().getSuccessor());
        } else {
            this.sequitur.lastSymbol = ruleSymbol;
        }
    }

    private void detectDigrams() {
        for (Rule rule : this.sequitur.getRules().values()) {
            if (rule.getElements().size() != 2) continue;
            Digram ruleDigram = new Digram(rule.getAnchor().getSuccessor(), rule.getAnchor().getSuccessor().getSuccessor());
            ruleDigram.setRule(rule);
            this.currentRules.put(ruleDigram, rule);
            this.replacedDigrams.put(ruleDigram, ruleDigram);
            LOG.trace("Digram: " + ruleDigram);
        }
    }
}

