/*
 * Decompiled with CFR 0.152.
 */
package de.dagere.requitur;

import de.dagere.requitur.Digram;
import de.dagere.requitur.ReducedTraceElement;
import de.dagere.requitur.Sequitur;
import de.dagere.requitur.Symbol;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Rule {
    private static final Logger LOG = LogManager.getLogger(Rule.class);
    private final Sequitur sequitur;
    private final Symbol anchor;
    private String name;
    int usage;

    public Rule(Sequitur sequitur, int index, Digram existing) {
        this.sequitur = sequitur;
        this.anchor = new Symbol(this.sequitur, null, this);
        this.name = "#" + index;
        LOG.debug("Create rule: " + this.name);
        this.setDigram(existing);
    }

    public void setDigram(Digram existing) {
        if (this.usage != 0) {
            throw new RuntimeException("Trying to re-use an already in-use rule!");
        }
        Symbol start = new Symbol(this.sequitur, existing.getStart());
        Symbol end = new Symbol(this.sequitur, existing.getEnd());
        this.sequitur.digrams.remove(existing);
        this.sequitur.link(this.anchor, start);
        this.sequitur.link(end, this.anchor);
        start.setSuccessor(end);
        end.setPredecessor(start);
        Digram ruleDigram = new Digram(start, end);
        ruleDigram.rule = this;
        this.useRule(existing, new Symbol(this.sequitur, this));
        this.sequitur.digrams.put(ruleDigram, ruleDigram);
    }

    public Symbol getAnchor() {
        return this.anchor;
    }

    public void decrementUsage() {
        --this.usage;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ReducedTraceElement> getElements() {
        LinkedList<ReducedTraceElement> result = new LinkedList<ReducedTraceElement>();
        for (Symbol iterator = this.anchor.getSuccessor(); iterator != this.anchor; iterator = iterator.getSuccessor()) {
            LOG.trace((Object)iterator);
            result.add(new ReducedTraceElement(iterator.getValue(), iterator.getOccurences()));
        }
        return result;
    }

    public Symbol use(Digram digram) {
        if (this.usage == 0) {
            LOG.error("Trying to re-use unused rule " + this.name + " " + this.anchor.getValue() + " " + this.anchor.getSuccessor() + " " + this.anchor.getSuccessor().getSuccessor());
            throw new RuntimeException("Can not re-use unused rule!");
        }
        Symbol ruleSymbol = new Symbol(this.sequitur, this);
        this.useRule(digram, ruleSymbol);
        return ruleSymbol;
    }

    private void useRule(Digram digram, Symbol ruleSymbol) {
        digram.rule = this;
        ++this.usage;
        digram.getStart().getPredecessor().setSuccessor(ruleSymbol);
        ruleSymbol.setPredecessor(digram.getStart().getPredecessor());
        if (digram.getEnd().getSuccessor() != null) {
            digram.getEnd().getSuccessor().setPredecessor(ruleSymbol);
            ruleSymbol.setSuccessor(digram.getEnd().getSuccessor());
        } else {
            this.sequitur.lastSymbol = ruleSymbol;
        }
        this.removeInvalidatedDigrams(digram, ruleSymbol);
        digram.getStart().decrementUsage(this);
        digram.getEnd().decrementUsage(this);
    }

    private void removeInvalidatedDigrams(Digram digram, Symbol ruleSymbol) {
        if (digram.getStart().getPredecessor().getValue() != null) {
            LOG.trace((Object)digram);
            Digram prevDigram = new Digram(digram.getStart().getPredecessor(), digram.getStart());
            LOG.trace("Searching digram: " + prevDigram);
            Digram oldDigram = this.sequitur.digrams.get(prevDigram);
            if (oldDigram.getStart() == digram.getStart().getPredecessor() && oldDigram.getEnd() == digram.getStart()) {
                this.sequitur.digrams.remove(oldDigram);
            }
            Digram newDigram = new Digram(digram.getStart().getPredecessor(), ruleSymbol);
            this.sequitur.handleDigram(newDigram);
            if (newDigram.getStart().getPredecessor() == newDigram.getEnd().getSuccessor()) {
                newDigram.rule = newDigram.getEnd().getSuccessor().getRule();
            }
        }
        if (digram.getEnd().getSuccessor() != null && digram.getEnd().getSuccessor().getValue() != null) {
            Digram overlappingDigram;
            Digram sucDigram = new Digram(digram.getEnd(), digram.getEnd().getSuccessor());
            this.sequitur.digrams.remove(sucDigram);
            if (digram.getEnd().getSuccessor().getSuccessor() != null && (overlappingDigram = new Digram(digram.getEnd().getSuccessor(), digram.getEnd().getSuccessor().getSuccessor())).equals(sucDigram)) {
                this.sequitur.digrams.put(overlappingDigram, overlappingDigram);
            }
            Digram newDigram = new Digram(ruleSymbol, digram.getEnd().getSuccessor());
            this.sequitur.handleDigram(newDigram);
            if (newDigram.getStart().getPredecessor() == newDigram.getEnd().getSuccessor()) {
                newDigram.rule = newDigram.getEnd().getSuccessor().getRule();
            }
        }
    }

    public String toString() {
        String result = this.name + " -> [";
        for (Symbol iterator = this.anchor.getSuccessor(); iterator != this.anchor && result.length() < 10000; iterator = iterator.getSuccessor()) {
            result = iterator.getOccurences() == 1 ? result + iterator.getValue() + " " : result + iterator.getOccurences() + " x " + iterator.getValue() + " ";
        }
        return result + "]";
    }

    public int getUsage() {
        return this.usage;
    }
}

